/**
　 * <p>Title: FGDBDataSource.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.datasource.fgdb;


import com.alibaba.fastjson.JSON;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.AbstractDataSource;
import com.northpool.resources.datasource.IDataSource;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;


/**
 * @author matt
 * 
 */
@ADataSource(name = "fgdb" ,types = "fgdb,gdb")
public class FGDBDataSource extends AbstractDataSource implements IDataSource {
    
   
    private String filePath;
    

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FGDBDataSource(String filePath){
        this.filePath = filePath;
        if(this.id == null){
            this.id = this.processFileURL(filePath);
        }
        this.dataSourceType = DATA_SOURCE_TYPE.fgdb;
    }
    
    
    public FGDBDataSource(String id,String filePath){
        this.filePath = filePath;
        if(this.id == null){
            this.id = this.processFileURL(filePath);
        }
    }
    
    private String processFileURL(String filePath){
        Path path = Paths.get(filePath);
        ArrayList<String> array = new ArrayList<>();
        Iterator<Path> iterator = path.iterator();
        while(iterator.hasNext()){
            array.add(iterator.next().toString());
        }
        return String.join("|", array);
    }
    
    
    FGDBDataSource(){
        
    }
    
    @Override
    public String toJson() {
        // TODO Auto-generated method stub
        return JSON.toJSON(this).toString();
    }

    @Override
    public String mark() {
        // TODO Auto-generated method stub
        return new StringBuilder().append(this.dataSourceType.name()).append('_').append(this.processFileURL(this.filePath)).toString();
    }

    
    @Override
    public void testConnection() throws Exception {
        // TODO Auto-generated method stub
        FGDB_GDALShell shell = new FGDB_GDALShell(this.filePath);
        shell.load();
    
    }

 
    @SuppressWarnings("unchecked")
    @Override
    public FGDBConnection connection() {
        return new FGDBConnection(this.filePath);
    }

    
    @Override
    public void resetConnection() {
        // TODO Auto-generated method stub
        
    }

    
    @Override
    public void destory() {
        // TODO Auto-generated method stub
        GDBPool.getPool().close(this.filePath);
    }

    public void create(){
        FGDB_ESRIShell.create(this.filePath);
    }

    @Deprecated
    @Override
    public ResultSet getSqlQuery(String sql) {
        return null;
    }

    @Deprecated
    @Override
    public Boolean executeSqlCommand(String sql) {
        return null;
    }



}
