/**
　 * <p>Title: AbstractGdbDAO.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月1日
　 * @version 1.0
*/
package com.northpool.resources.datatable.fgdb;

import com.northpool.commons.reflect.Bean;
import com.northpool.exception.UException;
import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.sql.*;
import com.northpool.type.Type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;



/**
 * @author matt
 *
 */
public class AbstractFGDBDAO<PK,T> implements IDAO<T,PK> {

    protected IDataSource dataSource;

    protected FGDBDialect dialect;
    
    protected FGBDTable fgdbTable;
    
    protected Class<?> clazz;
    
    protected IFGDBTransformer<T> transformer; 
    
    
    
    public AbstractFGDBDAO(IDataSource dataSource, FGBDTable fgdbTable,IFGDBTransformer<T> transformer) {
        this.dataSource = dataSource;
        this.dialect = (FGDBDialect)IDialect.getByType(dataSource.getDataSourceType());
        this.fgdbTable = fgdbTable;
        this.transformer = transformer;

    }

    @Override
    public T get(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public Long count(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public List<T> query(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public List<T> query(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.fgdbTable,queryFilter).exceptSpatialFilter();
        } catch (Exception e) {
            UException.printStackTrace(e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();

        // IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer,parameter.getSpatialCommand());

        IQuery<T,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(),parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer, parameter.getSpatialCommand());

        return query.list();
    }

    
    @Override
    public List<Object[]> queryArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        ISQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.fgdbTable,queryFilter);
        } catch (Exception e) {
            UException.printStackTrace(e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();

        // IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer,parameter.getSpatialCommand());

        IQuery<Object[],IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(),parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), IFGDBTransformer.ARRAY, parameter.getSpatialCommand());


        return query.list();
    }

    
    
    
    
    
    private <ST> IScroll<ST> _scroll(QueryFilter queryFilter, Integer fetchSize,IFGDBTransformer<ST> transformer) throws DataAccessException {
        // TODO Auto-generated method stub
        
        ISQLQueryEngine engine = null;
        try {
             engine = new SQLQueryEngine(this.fgdbTable,queryFilter).exceptSpatialFilter().doNotUseAliasName();
        } catch (Exception e) {
            UException.printStackTrace(e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        
       // IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer,parameter.getSpatialCommand());
        
        IQuery<ST,IFGDBTransformer<?>> query = this.createQuery(parameter.getSql(),parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer, parameter.getSpatialCommand());
        
        
        return query.scroll();
    }

   
    @Override
    public IScroll<T> scroll(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.scroll(queryFilter, null);
    }

    
  
    
    @Override
    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IFGDBTransformer.ARRAY);
    }

    
    @Override
    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

  
    
    public void insert(T t,boolean insertNull) throws DataAccessException {
        // TODO Auto-generated method stub
        
        int size = this.fgdbTable.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.fgdbTable.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }
        Object[] args = null;
        if(insertNull){
            args = new Object[size];
           
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
           //     String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                args[i] = Bean.getObjectValueByFieldName(t, fieldName);
            }
        }else{
            List<String> newFieldInDb = new ArrayList<>(size);
            List<Object> argsList = new ArrayList<>(size);
            List<Type> typeList = new ArrayList<>(size);
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                Object o = Bean.getObjectValueByFieldName(t, fieldName);
                if(o != null){
                    newFieldInDb.add(fieldInDB);
                    argsList.add(o);
                    typeList.add(this.fgdbTable.getFieldsInTableMap().get(fieldInDB).getType());
                }
                
            }
            fieldsInDB = newFieldInDb.toArray(new String[newFieldInDb.size()]);
            args = argsList.toArray(new Object[argsList.size()]);
            types = typeList.toArray(new Type[typeList.size()]);
        }
        
        IDML insert = this.createInsert(fgdbTable,fieldsInDB,types);
        
        insert.insert(args);
        
        return;
        
    }
    
    
    private IDML createInsert(final FGBDTable fgdbTable,final String[] fieldsInDB, final Type[] types){
        IDML update = new FGDBDML(this.dataSource, dialect, fgdbTable.getTablename(),fieldsInDB,FGDBDML.DML_TYPE.insert);
        update.setInputTypes(types);
        return update;
    }

   
    @Override
    public void saveOrUpdate(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

   
    @Override
    public void remove(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

   
    @Override
    public void update(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

   
    @Override
    public void removeAll() throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

   
    @Override
    public void insertMany(List<T> list) throws DataAccessException {
        // TODO Auto-generated method stub
        this.insertMany(list, IDAO.DEFALT_BATCH_SIZE);        
    }

   
    
    public void insertMany(List<T> list, Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        
        int size = this.fgdbTable.fields().length;
        ArrayList<String> fieldsInDBArr = new ArrayList<>();
        ArrayList<String> fieldsArr = new ArrayList<>();
        ArrayList<Type> typesArr = new ArrayList<>();
        for(int index = 0 ; index < size ; index ++){
            IField field = this.fgdbTable.fields()[index];
            if(field.isPK()){
                continue;
            }
            fieldsInDBArr.add(field.getOriginFieldName());
            fieldsArr.add(field.getFieldName());
            typesArr.add(field.getType());
            
        }
        String[] fieldsInDB = fieldsInDBArr.toArray(new String[fieldsInDBArr.size()]);
        String[] fields = fieldsArr.toArray(new String[fieldsArr.size()]);
        Type[] types = typesArr.toArray(new Type[typesArr.size()]);
        
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<T> iterator = list.iterator();
            @Override
            public boolean hasNext() {
                // TODO Auto-generated method stub
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                T data = iterator.next();
                Object[] values = new Object[fields.length];
                // TODO Auto-generated method stub
                for(int i = 0 ; i < fields.length ; i ++){
                    String field = fields[i];
                    Object value = Bean.getObjectValueByFieldName(data, field);
                    values[i] = value;
                }
                return values;
            }

            @Override
            public int size() {
                // TODO Auto-generated method stub
                return list.size();
            }
            
        };
        
        IDML batchInsert = new FGDBDML(this.dataSource, dialect, fgdbTable.getTablename(),fieldsInDB,FGDBDML.DML_TYPE.batchInsert);
        
        batchInsert.setInputTypes(types);
        batchInsert.setBatchSize(batchSize);
        batchInsert.batchInsert(scroll);
        
        return;
        
        
        
        
    }

    
    @Override
    public void insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        
        String[] fieldsInDB = new String[fields.length];
        Type[] types = new Type[fields.length];
        Map<String,IField> mapField = fgdbTable.getFieldsMap();
        for(int i = 0 ; i < fields.length ; i++){
            String field = fields[i];
            IField dbField = mapField.get(field);
            if(dbField == null){
                throw new RuntimeException(String.format("表:%s中没有找到字段", fgdbTable.mark(),dbField));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
        }
        
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<Object[]> iterator = list.iterator();
            @Override
            public boolean hasNext() {
                // TODO Auto-generated method stub
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                Object[] data = iterator.next();
                for(int i = 0 ; i < data.length ; i ++){
                    Type type = types[i];
                   
                    data[i] = type.toType(data[i]);
                }
                return data;
            }

            @Override
            public int size() {
                // TODO Auto-generated method stub
                return list.size();
            }
            
        };
        
        IDML batchInsert = new FGDBDML(this.dataSource, dialect, fgdbTable.getTablename(),fieldsInDB,FGDBDML.DML_TYPE.batchInsert);
        
        batchInsert.setInputTypes(types);
        batchInsert.setBatchSize(batchSize);
        batchInsert.batchInsert(scroll);
        
        
    }

   
    @Override
    public void updateMany(T o, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    
    @Override
    public void remove(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insert(java.lang.Object)
     */
    @Override
    public void insert(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    //先写,以后需要合并的方法
    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; i++) {
            Object arg = args[i];
            Type t = this.dialect.getTypeByObject(arg);
            types[i] = t;
        }
        return types;

    }
    
  
    
    
    @SuppressWarnings("rawtypes")
    protected <ST> IQuery<ST,IFGDBTransformer<?>> createQuery(final String sql,final String[] selectFieldArray, final Object[] args, final Type[] types,
        final Integer firstResult, final Integer maxResults, final Map<String, Type> returnType,
        final IFGDBTransformer<ST> transformer,final SpatialCommand command) throws DataAccessException {

        @SuppressWarnings("unchecked")
        IQuery<ST,IFGDBTransformer<?>> query = new FGDBQuery(this.dataSource, dialect, sql, selectFieldArray, fgdbTable, command);
        query.setResultTransformer(transformer);

        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes;
            if (types == null) {
                inTypes = this.guessType(args);
            } else {
                inTypes = types;
            }
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }

        query.setFirstResult(firstResult).setMaxResults(maxResults);

        return query;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#scroll(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public IScroll scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return this._scroll(queryFilter, fetchSize, IFGDBTransformer.MAP);
    }
    


   
   

    
    
    
    
    
   

}
