/**
　 * <p>Title: FGDBQuery.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月29日
　 * @version 1.0 
*/
package com.northpool.resources.datatable.fgdb;


import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.dialect.fgdb.FGDBQueryParmsDataInput;
import com.northpool.resources.sql.IQuery;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.Geom;
import com.northpool.type.Type;


/**
 * @author matt
 *
 */
public class FGDBQuery<T> implements IQuery<T,IFGDBTransformer<T>> {

    FGDBDialect dialect;
    IFGDBTransformer<T> transformer;
    String sql;
    Map<String,Type> returnTypeMap = new HashMap<String,Type>();
    
    int firstResult = -1;
    int maxResults = -1;
    Integer fetchSize; 
    
    List<Type> inputTypes = new ArrayList<>();
    
    FGDBDataSource fgdbDataSource;
    
    boolean ignoreWarnings = false;
    
    static final Logger logger = LoggerFactory.getLogger(FGDBQuery.class);
    
    List<Object> parameterList = new ArrayList<Object>();
    
    SpatialCommand command;
    
    ITable table;
    
    String[] queryFields;
    
    
    /**
     * @param dataSource
     * @param dialect2
     * @param sql2
     */
    public FGDBQuery(IDataSource dataSource, FGDBDialect dialect, String sql,String[] queryFields,ITable table ,SpatialCommand command) {
        // TODO Auto-generated constructor stub
        this.fgdbDataSource = (FGDBDataSource)dataSource;
        this.dialect = dialect;
        this.sql = sql;
        this.command = command;
        this.table = table;
        this.queryFields = queryFields;
        
    }


    @Override
    public IQuery<T, IFGDBTransformer<T>> setResultTransformer(IFGDBTransformer<T> transformer) {
        this.transformer = transformer;
        return this;
    }

    
    @Override
    public IQuery<T, IFGDBTransformer<T>> addScalar(String key, Type type) {
        this.returnTypeMap.put(key, type);
        return this;
    }

   
    @Override
    public IQuery<T, IFGDBTransformer<T>> addScalar(Map<String, Type> returnTypeMap) {
        this.returnTypeMap = returnTypeMap;
        return this;
    }

   
    @Override
    public IQuery<T, IFGDBTransformer<T>> setParameter(int index, Object arg) {
        this.parameterList.add(index, arg);
        return this;
    }

    @Override
    public IQuery<T, IFGDBTransformer<T>> setFirstResult(Integer firstResult) {
        if(firstResult != null){
            this.firstResult = firstResult;
        }
        return this;
    }

    
    @Override
    public IQuery<T, IFGDBTransformer<T>> setMaxResults(Integer maxResults) {
        if(maxResults != null){
            this.maxResults = maxResults;
        }
        return this;
    }

    
    @Override
    public IQuery<T, IFGDBTransformer<T>> setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    
    @Override
    public IQuery<T, IFGDBTransformer<T>> setParameters(Object[] args) {
        this.parameterList.addAll(Arrays.asList(args));
        return this;
    }

   
    @Override
    public void setInputTypes(Type[] inputTypes) {
        if(inputTypes != null){
            this.inputTypes = new ArrayList<Type>(Arrays.asList(inputTypes));
        }
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.sql.IQuery#list()
     */
    @Override
    public List<T> list() throws DataAccessException {
       IScroll<T> scroll = this.scroll();
       List<T> list = new ArrayList<>();
       while (scroll.hasNext()){
           list.add(scroll.next());
       }
       return list;
    }


    protected void printSQL(){
        logger.debug(this.sql);
        logger.debug("use parameters:" + StringUtils.join(this.parameterList, ","));
    }
    
    /**
     * 将参数注入到SQL中
     * @param sql
     * @param args
     * @param types
     * @return
     */
    private String setValuesIntoSql(String sql,Object[] args,Type[] types){
        int size = args.length;
        if(args.length != types.length){
            throw new RuntimeException("查询时值的长度需要和类型的长度一致");
        }
        
        List<String> parmsList = new ArrayList<>();
        for(int i = 0 ; i < size ; i ++){
            FGDBQueryParmsDataInput.INSTANCE.input(parmsList, types[i], args[i] , i);
            sql = StringUtils.replaceOnce(sql, "?", parmsList.get(i));
        }
        return sql;
    }
    
    private Layer executeSQL(DataSource dataSource,String sql,SpatialCommand command){
        Layer layer = null;
        if(command == null){
            layer = dataSource.ExecuteSQL(sql);
        }else{
            command.build(dialect);
            
            
            Geom geom = command.getGeometry();
            geom.changeType(SPATIAL_TYPE.gdalGeometry);
            layer = dataSource.ExecuteSQL(sql,(org.gdal.ogr.Geometry)geom.getOriginGeom()); 
        }
        return layer;
    }
    
    
    @Override
    public IScroll<T> scroll() throws DataAccessException {
        this.printSQL();
       // final int fetchsize = this.fetchSize == null ? IDAO.DEFAULT_FETCH_SIZE : this.fetchSize;
        Object[] args = this.parameterList.toArray(new Object[this.parameterList.size()]);
        IScroll<T> scroll;
        try {
        
            Type[] types = this.inputTypes.toArray(new Type[this.inputTypes.size()]);
            
            String sql = this.setValuesIntoSql(this.sql, args,types);
            
            DataSource dataSource = this.fgdbDataSource.connection().getGDALShell().getDataSource();
            
            Layer layer = this.executeSQL(dataSource, sql, command);
            
            scroll = this.transformer.extractDataScroll(dialect, layer, returnTypeMap, new FGDBScrollStatement(this.table,this.queryFields,this.firstResult,this.maxResults));
           
        } catch (Exception e) {
            // TODO Auto-generated catch block
           throw new DataAccessException(e);
        }
        return scroll;
    }

}
