/**
　 * <p>Title: FGDBColumn.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datatable.fgdb.operate.column;

import com.northpool.resources.datatable.operate.AbstractColumn;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean.VALUE_TYPE;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.Constants.SPATIAL_TYPE;

/**
 * @author matt
 *
 */
public class FGDBColumn  extends AbstractColumn implements IColumn {

    /**
     * @param columnName
     * @param columnSize
     * @param digits
     * @param columnTypeName
     * @param nullable
     * @param defaultValue
     * @param remarks
     * @param dialect
     */
    public FGDBColumn(String columnName, Integer columnSize, String columnTypeName, Boolean nullable, String remarks) {
        super(columnName, columnSize, null, columnTypeName, nullable, null, remarks, FGDBDialect.INSTANCE);
        // TODO Auto-generated constructor stub
    }

    
    @Override
    public SPATIAL_TYPE getSpatialType() {
        // TODO Auto-generated method stub
        return SPATIAL_TYPE.shape;
    }

  
    @Override
    protected void initAttType() {
        // TODO Auto-generated method stub
        this.type = this.dialect.getTypeByName(this.columnTypeName);
        
    }

   
    @Override
    protected FieldDefaultValueBean getFieldDefaultValueByDefaultValue() {
        // TODO Auto-generated method stub
        return null;
    }
    
    public  static FGDBColumn createIdColumn(String name){
        FGDBColumn column = new FGDBColumn(name,0,"Integer",false,"主键");
        column.setIsPK(true);
        FieldDefaultValueBean fieldDefaultValueBean = new FieldDefaultValueBean();
        fieldDefaultValueBean.setType(VALUE_TYPE.serial);
        column.setFieldDefaultValue(fieldDefaultValueBean);
        column.setIsSerial(true);
        return column;
    }
    
    public  static FGDBColumn createSpatialColumn(String name,Integer srid,int OGRwkbGeometryType){
        FGDBColumn column = new FGDBColumn(name,0,"geometry",false,"空间字段");
        column.setIsSpatial(true);
        column.setSRID(srid);
        column.setGeoType(ogrwkbGeometryType2GeoType(OGRwkbGeometryType));
        column.setDimension(ogrwkbGeometryType2Dimension(OGRwkbGeometryType));
        return column;
    }

    static Integer ogrwkbGeometryType2Dimension(int OGRwkbGeometryType){
        switch(OGRwkbGeometryType){
            case 0:
                return 2;
            case 1:
                return 2;
            case 2:
                return 2;
            case 3:
                return 2;
            case 4:
                return 2;
            case 5:
                return 2;
            case 6:
                return 2;
            case 3000:
                return 3;
            case 3001:
                return 3;
            case 3002:
                return 3;
            case 3003:
                return 3;
            case 3004:
                return 3;
            case 3005:
                return 3;
            case 3006:
                return 3;
          
            default:
                throw new RuntimeException("找不到OGRwkbGeometryType:" + OGRwkbGeometryType + "与GEO_TYPE的映射关系");
            
        }
        
    }
    
    static GEO_TYPE ogrwkbGeometryType2GeoType(int OGRwkbGeometryType){
        switch(OGRwkbGeometryType){
            case 0:
                return GEO_TYPE.UNKNOWN;
            case 1:
                return GEO_TYPE.POINT;
            case 2:
                return GEO_TYPE.LINESTRING;
            case 3:
                return GEO_TYPE.POLYGON;
            case 4:
                return GEO_TYPE.MULTIPOINT;
            case 5:
                return GEO_TYPE.MULTILINESTRING;
            case 6:
                return GEO_TYPE.MULTIPOLYGON;
            case 3000:
                return GEO_TYPE.UNKNOWN;
            case 3001:
                return GEO_TYPE.POINT;
            case 3002:
                return GEO_TYPE.LINESTRING;
            case 3003:
                return GEO_TYPE.POLYGON;
            case 3004:
                return GEO_TYPE.MULTIPOINT;
            case 3005:
                return GEO_TYPE.MULTILINESTRING;
            case 3006:
                return GEO_TYPE.MULTIPOLYGON;
          
            default:
                throw new RuntimeException("找不到OGRwkbGeometryType:" + OGRwkbGeometryType + "与GEO_TYPE的映射关系");
            
        }

    }

}
