/**
　 * <p>Title: FGDBResourcesDataInput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月24日
　 * @version 1.0
*/
package com.northpool.resources.dialect.fgdb;


import java.math.BigDecimal;
import java.nio.ByteBuffer;

import java.util.Date;

import org.fgdbapi.thindriver.swig.Row;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.spatial.Geom;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeDouble;
import com.northpool.type.TypeFGDBGeometry;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeString;
import com.northpool.type.TypeTimestamp;

/**
 * @author matt
 *
 */
public class FGDBResourcesDataInput implements IResourcesDataInput<Row,String> {

    public static final FGDBResourcesDataInput INSATNCE = new FGDBResourcesDataInput();
    
    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        return DATA_SOURCE_TYPE.fgdb;
    }

   
    @Override
    public void columnBoolean(Row input, Object value, String indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName);
            return;
        }
        if(TypeBoolean.INSTANCE.isType(value)){
            Boolean bl = (Boolean)value;
            if(bl == true){
                input.setShort(indexOrLabelName,(short)1 );
            }else{
                input.setShort(indexOrLabelName,(short)0 );
            }
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeBoolean.INSTANCE,value,"值类型不符");
        }
    }

    
    @Override
    public void columnBigDecimal(Row input, Object value, String indexOrLabelName) throws Exception {
        
        if(value == null){
            input.setNull(indexOrLabelName);
            return;
        }
        if(TypeBigDecimal.INSTANCE.isType(value)){
            BigDecimal bigdecimal = (BigDecimal)value;
            input.setDouble(indexOrLabelName, bigdecimal.doubleValue());
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeBigDecimal.INSTANCE,value,"值类型不符");
        }
       
        
    }

    
    @Override
    public void columnBytes(Row input, Object value, String indexOrLabelName) throws Exception {
        // TODO Auto-generated method stub
        throw new RuntimeException("暂时不支持");
    }

    
    @Override
    public void columnDouble(Row input, Object value, String indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName);
            return;
        }
        if(TypeDouble.INSTANCE.isType(value)){
            input.setDouble(indexOrLabelName, (double)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeDouble.INSTANCE,value,"值类型不符");
        }
       
        
    }

   
    @Override
    public void columnGeometry(Row input, Object value, String indexOrLabelName) throws Exception {
        // TODO Auto-generated method stub
        if(value == null){
            throw new RuntimeException("空间字段不允许插入空");
        }
        if(TypeFGDBGeometry.INSTANCE.isType(value)){
           
            Geom geom = (Geom)value;
            byte[] bytes = (byte[])geom.getOriginGeom();
            input.setGeometry(bytes);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeDouble.INSTANCE,value,"值类型不符");
        }
    }

    
    @Override
    public void columnInteger(Row input, Object value, String indexOrLabelName) throws Exception {

        if(value == null){
            input.setNull(indexOrLabelName);
            return;
        }
        if(TypeInteger.INSTANCE.isType(value)){
            input.setInteger(indexOrLabelName, (int)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeInteger.INSTANCE,value,"值类型不符");
        }
        
        
       
    }

   
    @Override
    public void columnLong(Row input, Object value, String indexOrLabelName) throws Exception {
        // TODO Auto-generated method stub
        ///input.set
        //input.setInteger(indexOrLabelName, value);
        throw new RuntimeException("暂时不支持");
    }

    
    @Override
    public void columnString(Row input, Object value, String indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName);
            return;
        }
        if(TypeString.INSTANCE.isType(value)){
            input.setString(indexOrLabelName,(String)value);
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeString.INSTANCE,value,"值类型不符");
        }
        input.setString(indexOrLabelName, (String)value);
    }

    
    @Override
    public void columnTimestamp(Row input, Object value, String indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName);
            return;
        }
        if(TypeTimestamp.INSTANCE.isType(value)){
            Date d = (Date)value;
            input.setDate(indexOrLabelName,(long)(d.getTime() / 1000));
        }else{
            throw new ResourcesDataInputException(this.getDataSourceType(),TypeTimestamp.INSTANCE,value,"值类型不符");
        }
        
        
    }

}
