/**
　 * <p>Title: FGDBResourcesDataOutput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年7月2日
　 * @version 1.0
*/
package com.northpool.resources.dialect.fgdb;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import org.gdal.ogr.Feature;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.Geom;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeTimestamp;

/**
 * @author matt
 *
 */
public class FGDBResourcesDataOutput  implements  IResourcesDataOutput<Feature,Integer>{

    public static final FGDBResourcesDataOutput INSTANCE = new FGDBResourcesDataOutput();
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        // TODO Auto-generated method stub
        return DATA_SOURCE_TYPE.fgdb;
    }

  
    @Override
    public Boolean columnBoolean(Feature output, Integer indexOrLabelName) throws Exception {
        // TODO Auto-generated method stub
        
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        int value = output.GetFieldAsInteger(indexOrLabelName);
        
        
        return (boolean)TypeBoolean.INSTANCE.toType(value);
    }

   
    @Override
    public BigDecimal columnBigDecimal(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        double value = output.GetFieldAsDouble(indexOrLabelName);
        return new BigDecimal(value);
    }

  
    @Override
    public byte[] columnBytes(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        byte[] bytes = output.GetFieldAsBinary(indexOrLabelName);
        return bytes;
    }

    
    @Override
    public Double columnDouble(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        double value = output.GetFieldAsDouble(indexOrLabelName);
        return value;
    }

    
    @Override
    public Geom columnGeometry(Feature output, Integer indexOrLabelName) throws Exception {
        
        byte[] wkb = output.GetGeometryRef().ExportToWkb();
      // output.GetGeometryRef().ExportToWkt()
        GeoBuffer GeoBuffer = WkbDecoder.DECODER.toGeoBuffer(wkb);
        
        return new Geom(SPATIAL_TYPE.wkb,wkb);
    }

    
    @Override
    public Integer columnInteger(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        return output.GetFieldAsInteger(indexOrLabelName);
    }

   
    @Override
    public Long columnLong(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        
        return output.GetFieldAsInteger64(indexOrLabelName);
    }

    
    @Override
    public String columnString(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        return output.GetFieldAsString(indexOrLabelName);
    }

   
    @Override
    public Date columnTimestamp(Feature output, Integer indexOrLabelName) throws Exception {
        if(output.IsFieldNull(indexOrLabelName)){
            return null;
        }
        int[] pnYear = new int[1];
        int[] pnMonth = new int[1];
        int[] pnDay = new int[1];
        int[] pnHour = new int[1];
        int[] pnMinute = new int[1];
        float[] pfSecond = new float[1];
        int[] pnTZFlag = new int[1];
        output.GetFieldAsDateTime(indexOrLabelName, pnYear, pnMonth, pnDay, pnHour, pnMinute, pfSecond, pnTZFlag);
        //"yyyy-MM-dd HH:mm:ss"
        String dateStr = new StringBuilder().append(pnYear[0]).append("-").append(pnMonth[0]).append("-").append(pnDay[0]).append(" ")
            .append(pnHour[0]).append(":").append(pnMinute[0]).append(":").append(pfSecond[0]).toString();
        Date date = (Date)TypeTimestamp.INSTANCE.strToType(dateStr);
       // Calendar cal = Calendar.getInstance();
       // cal.set(pnYear[0], pnMonth[0], pnDay[0], pnHour[0], pnMinute[0], (int)pfSecond[0]);
        //cal.setTimeZone(TimeZone.getDefault());
       // Date date = cal.getTime();
       // Date date1 = new Date(pnYear[0], pnMonth[0], pnDay[0], pnHour[0], pnMinute[0], (int)pfSecond[0]);
        
        return date;
        
    }

}
