/**
 * <p>
 * Title: asaasdasd.java
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2019
 * </p>
 * <p>
 * Company: northpool
 * </p>
 * @author matt @date 2021年4月9日 @version 1.0
 */
package com.northpool.resources.dialect.fgdb;

import com.northpool.resources.datasource.fgdb.EsriTypeUtils;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.TableSchemaBean;

import java.io.StringWriter;
import java.util.Collection;
import java.util.UUID;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;

import org.eclipse.persistence.oxm.NamespacePrefixMapper;
import org.fgdbapi.thindriver.tools.Tools;
import org.fgdbapi.thindriver.xml.ArrayOfControllerMembership;
import org.fgdbapi.thindriver.xml.ArrayOfField;
import org.fgdbapi.thindriver.xml.ArrayOfIndex;
import org.fgdbapi.thindriver.xml.ArrayOfPropertySetProperty;
import org.fgdbapi.thindriver.xml.DEFeatureClass;
import org.fgdbapi.thindriver.xml.DETable;
import org.fgdbapi.thindriver.xml.DataElement;
import org.fgdbapi.thindriver.xml.EsriDatasetType;
import org.fgdbapi.thindriver.xml.EsriFeatureType;
import org.fgdbapi.thindriver.xml.EsriFieldType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.Fields;
import org.fgdbapi.thindriver.xml.Indexes;
import org.fgdbapi.thindriver.xml.Names;
import org.fgdbapi.thindriver.xml.ObjectFactory;
import org.fgdbapi.thindriver.xml.PropertySet;

/**
 * copy from org.fgdbapi.thindriver.xml modify
 * 
 * @author pfreydiere
 * @author matt
 */
public class FGDBTableBuilder {

    private DETable dataElement;

    private String name;
    
    private Field spatialField;
    
    
    public static final String ID_FIELD_NAME = "GDB_OBJECTID";
    
    TableSchemaBean tableSchemaBean;
    
    public FGDBTableBuilder(TableSchemaBean tableSchemaBean){
        this.tableSchemaBean = tableSchemaBean;
    }
    
    
    

    private void createTableAndPkIndex(TableSchemaBean tableSchemaBean) {
        
        String name = tableSchemaBean.getTableName();
        
        String[] tableNameArr = name.split("\\.");
        
        if(tableNameArr.length > 1){
            name = tableNameArr[tableNameArr.length - 1];
        }
        
        
       // FGDBTableBuilder th = new FGDBTableBuilder(name);

        Field o = new Field();
        o.setName(ID_FIELD_NAME);
        o.setType(EsriFieldType.ESRI_FIELD_TYPE_OID);
        o.setLength(4);
        o.setRequired(true);
        o.setIsNullable(false);
        o.setEditable(false);
        o.setAliasName(o.getName());
        o.setModelName("自增主键");

        Fields flds = new Fields();

        flds.setFieldArray(new ArrayOfField());
        flds.getFieldArray().getField().add(o); // adding objectid

       /* Index oid = new Index();
        oid.setName("pk_" + name);*/

     //   Fields sfields = new Fields();
     //   ArrayOfField indexsarrayOfField = new ArrayOfField();
     //   sfields.setFieldArray(indexsarrayOfField);
       // indexsarrayOfField.getField().add(o);

       // oid.setFields(sfields);
       // oid.setIsUnique(true);
       // oid.setIsAscending(true);

        ArrayOfIndex arrayOfIndex = new ArrayOfIndex();
     //   arrayOfIndex.getIndex().add(oid);

        this.dataElement = new DETable();

        Indexes indices = new Indexes();
        indices.setIndexArray(arrayOfIndex);
        this.dataElement.setIndexes(indices);

        this.dataElement.setCatalogPath("\\" + name);
        this.dataElement.setName(name);
        this.dataElement.setChildrenExpanded(false);
        this.dataElement.setOIDFieldName(ID_FIELD_NAME);
        this.dataElement.setHasOID(true);
        this.dataElement.setDatasetType(EsriDatasetType.ESRI_DT_TABLE);
        this.dataElement.setVersioned(false);
        this.dataElement.setControllerMemberships(new ArrayOfControllerMembership());

        // to be adjusted
        this.dataElement.setCLSID("{" + UUID.randomUUID().toString() + "}");

        this.dataElement.setModelName(name);
        this.dataElement.setAliasName(name);

        this.dataElement.setFields(flds);


    }

     void newTable(TableSchemaBean tableSchemaBean) throws Exception {
        this.createTableAndPkIndex(tableSchemaBean);

        DEFeatureClass fc = new DEFeatureClass();

        Tools.copy(this.dataElement, fc);

        this.dataElement = fc; 

        
        Collection<ColumnBean> collection = tableSchemaBean.getColumnMap().values();

        

        for(ColumnBean columnBean : collection){
            if(columnBean.getIsPK()){
                addIdColumn(columnBean);
            }else{
                Field field = FGDBFieldRefDialect.INSTANCE.column(this, columnBean);
                if(columnBean.getIsSpatial()){
                    this.spatialField = field;
                }
            }
        }
        
        
     /*   Field s = new Field();
        s.setName("SHAPE");
        s.setType(EsriFieldType.ESRI_FIELD_TYPE_GEOMETRY);
        s.setRequired(true);
        s.setIsNullable(true);
        s.setAliasName("SHAPE");
        s.setModelName("SHAPE");
        s.setEditable(true);

        GeometryDef geom = new GeometryDef();
        geom.setGeometryType(EsriGeometryType.ESRI_GEOMETRY_POLYGON);
        geom.setSpatialReference(EsriTypeUtils.constructCGCS2000SpatialReference());
        geom.setGridSize0((double) 0);

        geom.setHasM(false);
        geom.setHasZ(false);

        s.setGeometryDef(geom);

        Fields flds = th.dataElement.getFields();
        flds.getFieldArray().getField().add(s);*/
        
        
        
        

      /*   Index sindex = new Index();
         sindex.setName("FDO_SHAPE");
         Fields shapeIndexFields = flds;
         ArrayOfField shapeIndexArrayOfFields = new ArrayOfField();
         shapeIndexArrayOfFields.getField().add(s);
         shapeIndexFields.setFieldArray(shapeIndexArrayOfFields);
         sindex.setFields(shapeIndexFields);
         sindex.setIsAscending(true);
         sindex.setIsUnique(false);*/
        
       //  fc.getIndexes().getIndexArray().getIndex().add(sindex);

     /*   EnvelopeN e = new EnvelopeN();
        e.setXMin(-180);
        e.setXMax(180);
        e.setYMin(-90);
        e.setYMax(90);
        fc.setExtent(e);*/

        fc.setFeatureType(EsriFeatureType.ESRI_FT_SIMPLE);
        fc.setShapeType(spatialField.getGeometryDef().getGeometryType());

        fc.setRelationshipClassNames(new Names());
        fc.setShapeFieldName(spatialField.getName());
        fc.setHasM(false);
        fc.setHasZ(false);
        fc.setDatasetType(EsriDatasetType.ESRI_DT_FEATURE_CLASS);
        fc.setCLSID("{52353152-891A-11D0-BEC6-00805F7C4268}"); // simple
        // features
      //  fc.setCLSID("{" + UUID.randomUUID().toString() + "}");
        fc.setHasSpatialIndex(false);

        fc.setSpatialReference(spatialField.getGeometryDef().getSpatialReference());
    }

   
    
    
    void addIdColumn(ColumnBean columnBean) {
        String name = columnBean.getColumnName();
        if (ID_FIELD_NAME.equalsIgnoreCase(name)) {
            return;
        }
        Field field = EsriTypeUtils.getEsriField(columnBean);
        this.addField(field);

    }

    void addSpatialColumn(FGDBTableBuilder th, ColumnBean columnBean) {
        Field field = EsriTypeUtils.getEsriField(columnBean);
        th.addField(field);

    }

   
    DETable build() throws Exception {
        this.newTable(this.tableSchemaBean);
        PropertySet ps = new PropertySet();
        dataElement.setExtensionProperties(ps);
        ps.setPropertyArray(new ArrayOfPropertySetProperty());
        return dataElement;
    }

    public String buildCreateTableXML() throws Exception {
        return serializeElement(build());
    }

    public String getName() {
        return this.name;
    }

    protected String serializeElement(DETable de) throws Exception {

        class NP extends NamespacePrefixMapper {
            @Override
            public String getPreferredPrefix(String arg0, String arg1, boolean arg2) {
                if (arg0.equals("http://www.esri.com/schemas/ArcGIS/10.1"))
                    return "esri";
                if (arg0.equals("http://www.w3.org/2001/XMLSchema-instance"))
                    return "xsi";
                return null;
            }
        }

        JAXBContext isn = JAXBContext.newInstance(ObjectFactory.class.getPackage().getName());
        Marshaller m = isn.createMarshaller();
        m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
        m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", new NP());

        StringWriter sw = new StringWriter();
        m.marshal(new JAXBElement<DataElement>(new QName("http://www.esri.com/schemas/ArcGIS/10.1", "DataElement"),
            DataElement.class, de), sw);

        String rawResult = sw.getBuffer().toString();

        // event for empty values, we must put the xsi:type
        // this should not be here ... but not taken into consideration in the
        // Jaxb implementation

        rawResult = rawResult.replace("<ExtensionProperties", "<ExtensionProperties xsi:type=\"esri:PropertySet\"");
        rawResult = rawResult.replace("<PropertyArray", "<PropertyArray xsi:type=\"esri:ArrayOfPropertySetProperty\"");
        rawResult = rawResult.replace("<ControllerMemberships",
            "<ControllerMemberships xsi:type=\"esri:ArrayOfControllerMembership\"");
        rawResult = rawResult.replace("<Fields", "<Fields xsi:type=\"esri:Fields\"");
        rawResult = rawResult.replace("<FieldArray", "<FieldArray xsi:type=\"esri:ArrayOfField\"");
        rawResult = rawResult.replace("<Field ", "<Field xsi:type=\"esri:Field\" ");
        rawResult = rawResult.replace("<Field>", "<Field xsi:type=\"esri:Field\">");

        rawResult = rawResult.replace("<GeometryDef", "<GeometryDef xsi:type=\"esri:GeometryDef\"");
        rawResult = rawResult.replace("<Indexes", "<Indexes xsi:type=\"esri:Indexes\"");
        rawResult = rawResult.replace("<IndexArray", "<IndexArray xsi:type=\"esri:ArrayOfIndex\"");
        rawResult = rawResult.replace("<Index>", "<Index xsi:type=\"esri:Index\">");

        rawResult = rawResult.replace("<RelationshipClassNames", "<RelationshipClassNames xsi:type=\"esri:Names\"");

        return rawResult;
    }

    public FGDBTableBuilder addField(Field f) {
        this.dataElement.getFields().getFieldArray().getField().add(f);
        return this;
    }
    

}
