/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.fgdb;

import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.type.FGDBTypeUtils;
import com.northpool.spatial.Constants;
import org.fgdbapi.thindriver.xml.EsriGeometryType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.GeographicCoordinateSystem;
import org.fgdbapi.thindriver.xml.SpatialReference;

public class EsriTypeUtils {
    public static Field getEsriField(ColumnBean columnBean) {
        return FGDBTypeUtils.getEsriField(columnBean);
    }

    public static EsriGeometryType geomType2EsriGeometryType(Constants.GEO_TYPE geoType) {
        switch (geoType) {
            case UNKNOWN: {
                throw new RuntimeException("fgdb\u4e0d\u652f\u6301UNKNOWN\u6570\u636e\u7c7b\u578b");
            }
            case POINT: {
                return EsriGeometryType.ESRI_GEOMETRY_POINT;
            }
            case LINESTRING: {
                return EsriGeometryType.ESRI_GEOMETRY_POLYLINE;
            }
            case POLYGON: {
                return EsriGeometryType.ESRI_GEOMETRY_POLYGON;
            }
            case MULTIPOINT: {
                return EsriGeometryType.ESRI_GEOMETRY_POINT;
            }
            case MULTILINESTRING: {
                return EsriGeometryType.ESRI_GEOMETRY_POLYLINE;
            }
            case MULTIPOLYGON: {
                return EsriGeometryType.ESRI_GEOMETRY_POLYGON;
            }
        }
        throw new RuntimeException("fgdb\u4e0d\u652f\u6301" + geoType.name() + "\u6570\u636e\u7c7b\u578b");
    }

    public static SpatialReference getSpatialReferenceBySRID(int srid) {
        switch (srid) {
            case 4490: {
                return EsriTypeUtils.constructCGCS2000SpatialReference();
            }
            case 4326: {
                return EsriTypeUtils.constructW84SpatialReference();
            }
            case 4610: {
                return EsriTypeUtils.constructXIAN80SpatialReference();
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301SRID:" + srid);
    }

    public static GeographicCoordinateSystem constructW84SpatialReference() {
        GeographicCoordinateSystem gcs = new GeographicCoordinateSystem();
        gcs.setWKID(Integer.valueOf(4326));
        gcs.setWKT("GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]]");
        gcs.setHighPrecision(Boolean.valueOf(true));
        gcs.setXYScale(Double.valueOf(1.0E10));
        gcs.setXOrigin(Double.valueOf(-200.0));
        gcs.setYOrigin(Double.valueOf(-100.0));
        gcs.setZOrigin(Double.valueOf(-1000.0));
        gcs.setMOrigin(Double.valueOf(0.0));
        gcs.setZScale(Double.valueOf(100.0));
        gcs.setMScale(Double.valueOf(100.0));
        gcs.setXYTolerance(Double.valueOf(1.0E-10));
        gcs.setLeftLongitude(Double.valueOf(-180.0));
        return gcs;
    }

    public static GeographicCoordinateSystem constructCGCS2000SpatialReference() {
        GeographicCoordinateSystem gcs = new GeographicCoordinateSystem();
        gcs.setWKID(Integer.valueOf(4490));
        gcs.setWKT("GEOGCS[\"China Geodetic Coordinate System 2000\",DATUM[\"China_2000\",SPHEROID[\"CGCS2000\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"1024\"]],AUTHORITY[\"EPSG\",\"1043\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4490\"]]");
        gcs.setHighPrecision(Boolean.valueOf(true));
        gcs.setXYScale(Double.valueOf(1.0E10));
        gcs.setXOrigin(Double.valueOf(-180.0));
        gcs.setYOrigin(Double.valueOf(-90.0));
        gcs.setZOrigin(Double.valueOf(-100.0));
        gcs.setMOrigin(Double.valueOf(0.0));
        gcs.setZScale(Double.valueOf(100.0));
        gcs.setMScale(Double.valueOf(100.0));
        gcs.setXYTolerance(Double.valueOf(1.0E-10));
        gcs.setLeftLongitude(Double.valueOf(-180.0));
        return gcs;
    }

    public static GeographicCoordinateSystem constructXIAN80SpatialReference() {
        GeographicCoordinateSystem gcs = new GeographicCoordinateSystem();
        gcs.setWKID(Integer.valueOf(4610));
        gcs.setWKT("GEOGCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4610\"]]");
        gcs.setHighPrecision(Boolean.valueOf(true));
        gcs.setXYScale(Double.valueOf(1.0E10));
        gcs.setXOrigin(Double.valueOf(-180.0));
        gcs.setYOrigin(Double.valueOf(-90.0));
        gcs.setZOrigin(Double.valueOf(-100.0));
        gcs.setMOrigin(Double.valueOf(0.0));
        gcs.setZScale(Double.valueOf(100.0));
        gcs.setMScale(Double.valueOf(100.0));
        gcs.setXYTolerance(Double.valueOf(1.0E-10));
        gcs.setLeftLongitude(Double.valueOf(-180.0));
        return gcs;
    }
}

