/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.fgdb;

import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.exception.UException;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.ParameterException;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.dialect.fgdb.FGDBResourcesDataInput;
import com.northpool.resources.dialect.fgdb.FGDBTableBuilder;
import com.northpool.resources.dialect.fgdb.IndexXMLBean;
import com.northpool.type.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.fgdbapi.thindriver.FGDBLibrariesInitializer;
import org.fgdbapi.thindriver.swig.EnumRows;
import org.fgdbapi.thindriver.swig.FGDBJNIWrapper;
import org.fgdbapi.thindriver.swig.Geodatabase;
import org.fgdbapi.thindriver.swig.IndexDef;
import org.fgdbapi.thindriver.swig.Row;
import org.fgdbapi.thindriver.swig.Table;

public class FGDB_ESRIShell
implements Runnable {
    private String file;
    private Geodatabase geodatabase;
    public static final String GDB_DATA_CHANGE = "gdbDataChange";
    boolean loadOnlyMode = false;
    Date lastUseTime;
    Boolean isUse = false;
    private ConcurrentLinkedQueue<Cmd> cmdQueue = new ConcurrentLinkedQueue();
    ReentrantLock lock = new ReentrantLock();
    Condition notEmpty = this.lock.newCondition();
    protected EventContainer<Listener> eventContainer = new EventContainer();
    Table table;
    Thread thread;
    volatile boolean empty = false;
    volatile boolean isDestroy = false;

    FGDB_ESRIShell(String file) {
        this.file = file;
        this.init();
    }

    void init() {
        FGDBLibrariesInitializer.initLibraries();
        this.thread = new Thread(this);
        this.thread.setName(this.file + " \u5904\u7406\u7ebf\u7a0b");
        this.thread.start();
    }

    public void destroy() {
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.lock.lockInterruptibly();
                Cmd cmd = this.cmdQueue.poll();
                if (cmd == null) {
                    if (this.geodatabase != null) {
                        FGDBJNIWrapper.CloseGeodatabase((Geodatabase)this.geodatabase);
                        this.geodatabase.delete();
                    }
                    this.geodatabase = null;
                    this.isUse = false;
                    this.lastUseTime = new Date();
                    this.empty = true;
                    this.notEmpty.await();
                    if (!this.isDestroy) continue;
                    return;
                }
                try {
                    Object resuit = this.execute(cmd);
                    cmd.promise.complete(resuit);
                }
                catch (Exception e) {
                    UException.printStackTrace((Throwable)e);
                    cmd.promise.completeExceptionally(e);
                }
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    public void addCmd(Cmd cmd) {
        this.isUse = true;
        if (this.geodatabase == null) {
            this.geodatabase = FGDBJNIWrapper.openGeodatabase((String)this.file);
        }
        this.cmdQueue.offer(cmd);
        if (this.empty) {
            this.lock.lock();
            this.notEmpty.signal();
            this.lock.unlock();
            this.empty = false;
        }
    }

    public void onDataChange(Listener listener) {
        this.eventContainer.on(GDB_DATA_CHANGE, parameter -> listener.fire(parameter));
    }

    Object execute(Cmd cmd) throws Exception {
        Cmd.CMD_TYPE type = cmd.getType();
        String tableName = null;
        switch (type) {
            case getIndex: {
                try {
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                }
                catch (Exception e) {
                    throw new ParameterException("getIndex \u53c2\u6570\u5fc5\u987b\u662fString");
                }
                List<IndexXMLBean> indexList = this.getIndex(tableName);
                return indexList;
            }
            case createtable: {
                TableSchemaBean tableSchemaBean;
                try {
                    Object o = cmd.objects[0];
                    tableSchemaBean = (TableSchemaBean)o;
                }
                catch (Exception e) {
                    throw new ParameterException("createtable \u53c2\u6570\u5fc5\u987b\u662fTableSchemaBean ");
                }
                this.createtable(tableSchemaBean);
                this.eventContainer.syncFireEvent(GDB_DATA_CHANGE, new Object[]{type});
                return null;
            }
            case droptable: {
                try {
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                }
                catch (Exception e) {
                    throw new ParameterException("droptable \u53c2\u6570\u5fc5\u987b\u662fString");
                }
                this.dropTable(tableName);
                this.eventContainer.syncFireEvent(GDB_DATA_CHANGE, new Object[]{type});
                return null;
            }
            case createindex: {
                IIndex index;
                try {
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    index = (IIndex)cmd.objects[1];
                }
                catch (Exception e) {
                    throw new ParameterException("createindex \u53c2\u6570\u5fc5\u987b\u662fString,IndexBean");
                }
                this.createIndex(tableName, index);
                this.eventContainer.syncFireEvent(GDB_DATA_CHANGE, new Object[]{type});
                return null;
            }
            case dropindex: {
                String indexName;
                try {
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    indexName = (String)cmd.objects[1];
                }
                catch (Exception e) {
                    throw new ParameterException("dropindex \u53c2\u6570\u5fc5\u987b\u662fString,String");
                }
                this.dropIndex(tableName, indexName);
                this.eventContainer.syncFireEvent(GDB_DATA_CHANGE, new Object[]{type});
                return null;
            }
            case insertbatch: {
                List objectsList;
                Type[] types;
                String[] fields;
                try {
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    Object o1 = cmd.objects[1];
                    fields = (String[])o1;
                    Object o2 = cmd.objects[2];
                    types = (Type[])o2;
                    Object o3 = cmd.objects[3];
                    objectsList = (List)o3;
                }
                catch (Exception e) {
                    throw new ParameterException("insert \u53c2\u6570\u5fc5\u987b\u662fString,String[],Type[],List<Object[]>");
                }
                this.insertBatch(tableName, fields, types, objectsList);
                this.eventContainer.syncFireEvent(GDB_DATA_CHANGE, new Object[]{type});
                return null;
            }
            case insert: {
                Object[] objects;
                Type[] types;
                String[] fields;
                try {
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    Object o1 = cmd.objects[1];
                    fields = (String[])o1;
                    Object o2 = cmd.objects[2];
                    types = (Type[])o2;
                    Object o3 = cmd.objects[3];
                    objects = (Object[])o3;
                }
                catch (Exception e) {
                    throw new ParameterException("insert \u53c2\u6570\u5fc5\u987b\u662fString,String[],Type[],Object[]");
                }
                int id = this.insert(tableName, fields, types, objects);
                this.eventContainer.syncFireEvent(GDB_DATA_CHANGE, new Object[]{type});
                return id;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u64cd\u4f5c" + (Object)((Object)type));
    }

    private void dropIndex(String tableName, String indexName) throws Exception {
        Table table = this.getTable(tableName);
        if (table == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u8868 " + tableName);
        }
        table.DeleteIndex(indexName);
    }

    List<IndexXMLBean> getIndex(String tableName) throws Exception {
        Table table = this.getTable(tableName);
        if (table == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u8868 " + tableName);
        }
        int size = (int)table.getIndexes().size();
        ArrayList<IndexXMLBean> iii = new ArrayList<IndexXMLBean>(size);
        for (int i = 0; i < size; ++i) {
            String xml = table.getIndexes().get(i);
            IndexXMLBean bean = IndexXMLBean.fromXML(xml.getBytes("utf-8"));
            iii.add(bean);
        }
        return iii;
    }

    Table getTable(String tableName) {
        try {
            Table table = this.geodatabase.openTable("\\" + tableName);
            return table;
        }
        catch (Exception e) {
            return null;
        }
    }

    void closeTable(Table table) {
        this.geodatabase.closeTable(table);
        table.delete();
    }

    void createtable(TableSchemaBean tableSchemaBean) throws Exception {
        FGDBTableBuilder FGDBTableBuilder2 = new FGDBTableBuilder(tableSchemaBean);
        this.geodatabase.createTable(FGDBTableBuilder2.buildCreateTableXML(), "");
        List<IndexXMLBean> indexXMLBeanList = this.getIndex(tableSchemaBean.getTableName());
        for (IndexXMLBean indexXMLBean : indexXMLBeanList) {
            if (!"esriFieldTypeGeometry".equalsIgnoreCase(indexXMLBean.getFields().get(0).getType())) continue;
            this.dropIndex(tableSchemaBean.getTableName(), indexXMLBean.getName());
        }
        FGDBJNIWrapper.CloseGeodatabase((Geodatabase)this.geodatabase);
        this.geodatabase.delete();
        this.geodatabase = null;
    }

    void dropTable(String tableName) {
        Table table = this.getTable(tableName);
        if (table != null) {
            this.closeTable(table);
            this.geodatabase.Delete("\\" + tableName, "Table");
        }
    }

    void createIndex(String tableName, IIndex index) throws Exception {
        Table table = this.getTable(tableName);
        if (table == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u8868 " + tableName);
        }
        IndexDef indexDef = new IndexDef(index.getName(), String.join((CharSequence)",", index.getColnames()), index.getUnique().booleanValue());
        table.AddIndex(indexDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(String tableName, String idFieldName, String where) throws Exception {
        Table table = this.getTable(tableName);
        if (table == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u8868 " + tableName);
        }
        try {
            EnumRows enumRows = table.search(idFieldName, where, true);
            table.setWriteLock();
            Row row = null;
            while ((row = enumRows.next()) != null) {
                table.deleteRow(row);
            }
            table.freeWriteLock();
            row.delete();
            enumRows.delete();
        }
        finally {
            this.closeTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int insert(String tableName, String[] fields, Type[] types, Object[] objects) throws Exception {
        int id;
        Table table = this.getTable(tableName);
        if (table == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u8868 " + tableName);
        }
        try {
            table.setWriteLock();
            id = this._insert(table, fields, types, objects, true);
            table.freeWriteLock();
        }
        finally {
            this.closeTable(table);
        }
        return id;
    }

    int _insert(Table table, String[] fields, Type[] types, Object[] objects, Boolean needReturn) throws Exception {
        Row row = table.createRowObject();
        for (int i = 0; i < fields.length; ++i) {
            Type type = types[i];
            Object object = objects[i];
            String fieldName = fields[i];
            FGDBResourcesDataInput.INSATNCE.input(row, type, object, fieldName);
        }
        table.insertRow(row);
        row.delete();
        if (needReturn.booleanValue()) {
            return row.getOid();
        }
        return 0;
    }

    void update(String tableName, String[] fields, Object[] objects, Type[] types) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertBatch(String tableName, String[] fields, Type[] types, List<Object[]> objectsList) throws Exception {
        this.table = this.getTable(tableName);
        if (this.table == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u8868 " + tableName);
        }
        long a1 = System.currentTimeMillis();
        try {
            this.table.setWriteLock();
            for (Object[] objects : objectsList) {
                this._insert(this.table, fields, types, objects, false);
            }
            this.table.freeWriteLock();
        }
        finally {
            this.closeTable(this.table);
        }
    }

    public static void create(String fileName) {
        FGDBLibrariesInitializer.initLibraries();
        FGDBJNIWrapper.createGeodatabase((String)fileName);
    }

    public void close() {
        if (this.geodatabase != null) {
            FGDBJNIWrapper.CloseGeodatabase((Geodatabase)this.geodatabase);
            this.geodatabase.delete();
        }
        this.lock.lock();
        this.isDestroy = true;
        this.notEmpty.signal();
        this.lock.unlock();
    }
}

