/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.fgdb;

import com.northpool.exception.UException;
import com.northpool.resources.datatable.fgdb.operate.column.FGDBColumn;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.thindriver.gdal.GDALInitializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;

public class FGDB_GDALShell {
    private String file;
    private DataSource ds;
    private boolean loaded = false;
    private Driver driver;

    public void close() {
        this.ds.FlushCache();
        this.ds.delete();
    }

    public FGDB_GDALShell(String file) {
        this.file = file;
        try {
            this.tryInit();
        }
        catch (Exception e) {
            throw new RuntimeException("GDAL\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public void reload() throws IOException {
        this.ds.FlushCache();
        this.ds.delete();
        this.load();
    }

    private void tryInit() throws Exception {
        GDALInitializer.initLibraries();
        this.driver = ogr.GetDriverByName((String)"OpenFileGDB");
    }

    public synchronized void load() throws IOException {
        this.loaded = false;
        this.ds = this.driver.Open(this.file);
        if (this.ds == null) {
            throw new IOException("\u6587\u4ef6 " + this.file + "\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5408\u6cd5\u7684fgdb\u6587\u4ef6\u683c\u5f0f");
        }
        this.loaded = true;
    }

    public String[] getTables() {
        int layerCount = this.ds.GetLayerCount();
        String[] tables = new String[layerCount];
        for (int i = 0; i < layerCount; ++i) {
            tables[i] = this.ds.GetLayer(i).GetName();
        }
        return tables;
    }

    public boolean hasTable(String tableName) {
        return this.getTable(tableName) != null;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    private Layer getTable(String tableName) {
        int layerCount = this.ds.GetLayerCount();
        for (int i = 0; i < layerCount; ++i) {
            if (!this.ds.GetLayer(i).GetName().equalsIgnoreCase(tableName)) continue;
            return this.ds.GetLayer(i);
        }
        return null;
    }

    public LinkedHashMap<String, IColumn> getColumnMap(String tableName) throws TableNotFoundException {
        LinkedHashMap<String, IColumn> map = new LinkedHashMap<String, IColumn>();
        Layer layer = this.getTable(tableName);
        if (layer == null) {
            throw new TableNotFoundException(tableName);
        }
        int fieldsCount = layer.GetLayerDefn().GetFieldCount();
        for (int i = 0; i < fieldsCount; ++i) {
            FieldDefn fieldDefn = layer.GetLayerDefn().GetFieldDefn(i);
            String columnName = fieldDefn.GetName();
            int columnSize = fieldDefn.GetWidth();
            boolean nullable = false;
            if (fieldDefn.IsNullable() == 1) {
                nullable = true;
            }
            String columnTypeName = fieldDefn.GetTypeName();
            String remarks = fieldDefn.GetAlternativeName();
            FGDBColumn column = new FGDBColumn(columnName, columnSize, columnTypeName, nullable, remarks);
            map.put(columnName, column);
        }
        String idColumnName = layer.GetFIDColumn();
        FGDBColumn idFGDBColumn = FGDBColumn.createIdColumn(idColumnName);
        map.put(idColumnName, idFGDBColumn);
        String spatialColumnName = layer.GetGeometryColumn();
        Integer SRID = this.getSRID(tableName);
        FGDBColumn spatialFGDBColumn = FGDBColumn.createSpatialColumn(spatialColumnName, SRID, layer.GetGeomType());
        map.put(spatialColumnName, spatialFGDBColumn);
        return map;
    }

    private Integer getSRID(String tableName) {
        Integer srid = null;
        Layer layer = this.getTable(tableName);
        SpatialReference spatialReference = layer.GetSpatialRef();
        try {
            srid = Integer.valueOf(spatialReference.GetAttrValue("AUTHORITY", 1));
            return srid;
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            srid = null;
            return null;
        }
    }

    public static void main(String[] aaa) throws Exception {
    }

    public String geTableRemarks(String tableName) throws TableNotFoundException {
        Layer layer = this.getTable(tableName);
        if (layer == null) {
            throw new TableNotFoundException(tableName);
        }
        return layer.GetDescription();
    }
}

