/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.fgdb;

import com.northpool.resources.datasource.fgdb.FGDB_ESRIShell;
import com.northpool.resources.datasource.fgdb.FGDB_GDALShell;
import java.io.IOException;
import java.util.HashMap;

class GDBPool {
    static GDBPool GDBPool = new GDBPool();
    static HashMap<String, FGDB_ESRIShell> esripool = new HashMap();
    static HashMap<String, FGDB_GDALShell> gdalpool = new HashMap();

    public static GDBPool getPool() {
        return GDBPool;
    }

    GDBPool() {
    }

    synchronized void close(String file) {
        FGDB_GDALShell gdal_shell = gdalpool.get(file);
        gdalpool.remove(file);
        if (gdal_shell != null) {
            gdal_shell.close();
        }
        FGDB_ESRIShell fgdb_shell = esripool.get(file);
        esripool.remove(file);
        if (fgdb_shell != null) {
            fgdb_shell.close();
        }
    }

    FGDB_GDALShell getFGDB_GDALShell(String file) {
        FGDB_GDALShell shell = gdalpool.get(file);
        if (shell == null) {
            try {
                shell = this.createFGDB_GDALShell(file);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return shell;
    }

    synchronized FGDB_GDALShell createFGDB_GDALShell(String file) throws IOException {
        FGDB_GDALShell shell = gdalpool.get(file);
        if (shell != null) {
            return shell;
        }
        shell = new FGDB_GDALShell(file);
        shell.load();
        gdalpool.put(file, shell);
        return shell;
    }

    FGDB_ESRIShell getFGDB_ESRIShell(String file) {
        FGDB_ESRIShell shell = esripool.get(file);
        if (shell == null) {
            shell = this.createFGDB_ESRIShell(file);
        }
        return shell;
    }

    synchronized FGDB_ESRIShell createFGDB_ESRIShell(String file) {
        FGDB_ESRIShell shell = esripool.get(file);
        if (shell != null) {
            return shell;
        }
        shell = new FGDB_ESRIShell(file);
        shell.onDataChange(parameter -> {
            FGDB_GDALShell gdalShell = gdalpool.get(file);
            try {
                gdalShell.reload();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        esripool.put(file, shell);
        return shell;
    }
}

