/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.fgdb.operate;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSourceOperator;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datasource.fgdb.FGDB_ESRIShell;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import java.util.List;
import java.util.concurrent.ExecutionException;

@ATableOperator(name="fgdb", type=Constants.DATA_SOURCE_TYPE.fgdb)
public class FGDBDataSourceOperator
implements IDataSourceOperator<FGDBDataSource> {
    public String[] tables(FGDBDataSource pool) {
        return pool.connection().getGDALShell().getTables();
    }

    public void drop(FGDBDataSource pool, String tableName) {
        FGDB_ESRIShell shell = pool.connection().getESRIShell();
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.droptable, tableName);
        shell.addCmd(cmd);
        try {
            cmd.getPromise().get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)e);
        }
    }

    public void createTableBySchemaBean(FGDBDataSource pool, TableSchemaBean tableSchemaBean) {
        FGDB_ESRIShell shell = pool.connection().getESRIShell();
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.createtable, tableSchemaBean);
        shell.addCmd(cmd);
        try {
            cmd.getPromise().get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new DataAccessException((Exception)e);
        }
    }

    public List<String> schemas(FGDBDataSource pool) {
        return null;
    }

    public Boolean hasSchema(FGDBDataSource pool, String schema) {
        return true;
    }

    public Boolean hasTable(FGDBDataSource pool, String tableName) {
        return pool.connection().getGDALShell().hasTable(tableName);
    }
}

