/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.fgdb;

import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.fgdb.IFGDBTransformer;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.IDML;
import com.northpool.type.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FGDBDML
implements IDML {
    protected FGDBDialect dialect;
    protected IFGDBTransformer<Void> transformer;
    protected Map<String, Type> returnTypeMap = new HashMap<String, Type>();
    protected Type[] inputTypes;
    protected FGDBDataSource dataSource;
    protected boolean ignoreWarnings = false;
    protected static final Logger logger = LoggerFactory.getLogger(FGDBDML.class);
    protected int batchsize;
    protected String tableName;
    protected String[] fields;
    protected DML_TYPE type;

    FGDBDML(IDataSource dataSource, FGDBDialect dialect, String tableName, String[] fields, DML_TYPE type) {
        this.dataSource = (FGDBDataSource)dataSource;
        this.dialect = dialect;
        this.tableName = tableName;
        this.fields = fields;
        this.type = type;
    }

    public IDML setBatchSize(int batchsize) {
        this.batchsize = batchsize;
        return this;
    }

    public void setInputTypes(Type[] inputTypes) {
        if (inputTypes != null) {
            this.inputTypes = inputTypes;
        }
    }

    public void insert(Object[] args) throws DataAccessException {
        Cmd insert = new Cmd(Cmd.CMD_TYPE.insert, this.tableName, this.fields, this.inputTypes, args);
        this.dataSource.connection().getESRIShell().addCmd(insert);
        try {
            int n = (Integer)insert.getPromise().get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new DataAccessException("fgdb\u63d2\u5165\u5931\u8d25,\u9519\u8bef:" + e.getMessage());
        }
    }

    public void batchInsert(IBatchDataScroll scroll) throws DataAccessException {
        int index = 0;
        ArrayList<Object[]> ii = new ArrayList<Object[]>(this.batchsize);
        while (scroll.hasNext()) {
            Object[] args = scroll.next();
            ii.add(args);
            if ((index + 1) % this.batchsize == 0) {
                this.insertList(ii);
            }
            ++index;
        }
        if (scroll.size() % this.batchsize != 0) {
            this.insertList(ii);
        }
    }

    private void insertList(List<Object[]> ii) {
        Cmd insertList = new Cmd(Cmd.CMD_TYPE.insertbatch, this.tableName, this.fields, this.inputTypes, ii);
        this.dataSource.connection().getESRIShell().addCmd(insertList);
        try {
            insertList.getPromise().get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            throw new DataAccessException("fgdb\u6279\u91cf\u63d2\u5165\u5931\u8d25,\u9519\u8bef:" + e.getMessage());
        }
        ii.clear();
    }

    public void update(Object[] args) throws DataAccessException {
    }

    public void batchUpdate(IBatchDataScroll scroll) throws DataAccessException {
    }

    public static enum DML_TYPE {
        insert,
        update,
        delete,
        batchInsert;

    }
}

