/**
　 * <p>Title: FGDB_ESRIShell.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datasource.fgdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

import org.fgdbapi.thindriver.FGDBLibrariesInitializer;
import org.fgdbapi.thindriver.swig.EnumRows;
import org.fgdbapi.thindriver.swig.FGDBJNIWrapper;
import org.fgdbapi.thindriver.swig.Geodatabase;
import org.fgdbapi.thindriver.swig.IndexDef;
import org.fgdbapi.thindriver.swig.Row;
import org.fgdbapi.thindriver.swig.Table;

import com.northpool.commons.collection.SetQueue;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.commons.util.FileUtil;
import com.northpool.exception.UException;
import com.northpool.resources.datasource.fgdb.Cmd.CMD_TYPE;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.IndexBean;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.fgdb.FGDBResourcesDataInput;
import com.northpool.resources.dialect.fgdb.FGDBTableBuilder;
import com.northpool.resources.dialect.fgdb.IndexXMLBean;
import com.northpool.resources.type.FGDBTypeUtils;
import com.northpool.type.Type;

/**
 * @author matt
 *
 */
public class FGDB_ESRIShell implements Runnable {
    private String file;
    private Geodatabase geodatabase;
    public static final String GDB_DATA_CHANGE = "gdbDataChange";
    boolean loadOnlyMode = false;
    Date lastUseTime;
    
    Boolean isUse = false;
        
    private ConcurrentLinkedQueue<Cmd> cmdQueue = new ConcurrentLinkedQueue<>();
    
    ReentrantLock lock =  new ReentrantLock();
    
    Condition notEmpty = lock.newCondition();
    
    protected EventContainer<Listener> eventContainer = new EventContainer<Listener>();
    
    Table table;
  
    Thread thread;
    
    volatile boolean empty = false;
    
    volatile boolean isDestroy  = false;
   
    FGDB_ESRIShell(String file){
       this.file = file;
       init();
      
    }
    
    void init(){
      //  this.watchService = FileSystems.getDefault().newWatchService();
        FGDBLibrariesInitializer.initLibraries();
        thread = new Thread(this);
        thread.setName(this.file + " 处理线程");
        thread.start();
    }
    
    public void destroy(){
        if(thread.isAlive()){
            thread.interrupt();
        }
    }
    
    
    
    
    
    @Override
    public void run() {
        // TODO Auto-generated method stub
        while(true){
            try {
                
                lock.lockInterruptibly();
                Cmd cmd = cmdQueue.poll();
                if(cmd == null){
                    if(this.geodatabase != null){
                    	FGDBJNIWrapper.CloseGeodatabase(this.geodatabase);
             		    this.geodatabase.delete();
                    }
                    this.geodatabase = null;
                    this.isUse = false;
                    this.lastUseTime = new Date();
                    this.empty = true;    
                    notEmpty.await();
                    if(isDestroy){
                        return;
                    }
                }else{
               //     System.out.println("do");
                    try {
                        Object resuit = this.execute(cmd);
                        cmd.promise.complete(resuit);
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        UException.printStackTrace(e);
                        cmd.promise.completeExceptionally(e);
                    }
                }
            } catch (InterruptedException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        }
    }
    
    public void addCmd(Cmd cmd) {
       
        this.isUse = true;
        try{
            if(geodatabase == null){
                this.geodatabase = FGDBJNIWrapper.openGeodatabase(this.file);
            }
            cmdQueue.offer(cmd);
            if(this.empty){
                lock.lock();
                notEmpty.signal();
                lock.unlock();
                this.empty = false;
            }
            
        }finally {
           
        }
    }
    
    
    
    
    
    public void onDataChange(Listener listener){
        eventContainer.on(GDB_DATA_CHANGE, (Object ...parameter) -> {
            listener.fire(parameter);
        });
    }
    
    Object execute(Cmd cmd) throws Exception{
        CMD_TYPE type = cmd.getType();
        String tableName = null;
        String[] fields;
        Type[] types;
        Object[] objects;
        List<Object[]> objectsList;
        IIndex index;
        String indexName;
        switch(type){
            case getIndex:
                try{
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                }catch(Exception e){
                    throw new ParameterException("getIndex 参数必须是String");
                }
                List<IndexXMLBean> indexList = this.getIndex(tableName);
              
                return indexList;
            case createtable:
                TableSchemaBean tableSchemaBean;
                try{
                    Object o = cmd.objects[0];
                    tableSchemaBean = (TableSchemaBean)o;
                }catch(Exception e){
                    throw new ParameterException("createtable 参数必须是TableSchemaBean ");
                }
                this.createtable(tableSchemaBean);
                eventContainer.syncFireEvent(GDB_DATA_CHANGE, type);
                return null;
            case droptable:
                try{
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                }catch(Exception e){
                    throw new ParameterException("droptable 参数必须是String");
                }
                this.dropTable(tableName);
                eventContainer.syncFireEvent(GDB_DATA_CHANGE, type);
                return null;
            case createindex:
                try{
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    index = (IIndex)cmd.objects[1];
                }catch(Exception e){
                    throw new ParameterException("createindex 参数必须是String,IndexBean");
                }
                this.createIndex(tableName, index);
                eventContainer.syncFireEvent(GDB_DATA_CHANGE, type);
                return null;
                
            case dropindex:
                try{
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    indexName = (String)cmd.objects[1];
                }catch(Exception e){
                    throw new ParameterException("dropindex 参数必须是String,String");
                }
                this.dropIndex(tableName, indexName);
                eventContainer.syncFireEvent(GDB_DATA_CHANGE, type);
                return null;
            case insertbatch:
                try{
                    //String tableName,String[] fields,Type[] types,Object[] objects
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    Object o1 = cmd.objects[1];
                    fields = (String[])o1;
                    Object o2 = cmd.objects[2];
                    types = (Type[])o2;
                    Object o3 = cmd.objects[3];
                    objectsList = (List<Object[]>)o3;
                }catch(Exception e){
                    throw new ParameterException("insert 参数必须是String,String[],Type[],List<Object[]>");
                }
               // long a = System.currentTimeMillis();
                this.insertBatch(tableName, fields, types, objectsList);
              //  System.out.println("__________________" + (System .currentTimeMillis() - a));
                
                eventContainer.syncFireEvent(GDB_DATA_CHANGE, type);
                return null;
            case insert:
                try{
                    //String tableName,String[] fields,Type[] types,Object[] objects
                    Object o = cmd.objects[0];
                    tableName = (String)o;
                    Object o1 = cmd.objects[1];
                    fields = (String[])o1;
                    Object o2 = cmd.objects[2];
                    types = (Type[])o2;
                    Object o3 = cmd.objects[3];
                    objects = (Object[])o3;
                }catch(Exception e){
                    throw new ParameterException("insert 参数必须是String,String[],Type[],Object[]");
                }
                int id = this.insert(tableName, fields, types, objects);
                eventContainer.syncFireEvent(GDB_DATA_CHANGE, type);
                return id;
            default:
                throw new RuntimeException("不支持操作" + type);
        }
        
    }
    
    /**
     * @param tableName
     * @param indexName
     * @throws Exception 
     */
    private void dropIndex(String tableName, String indexName) throws Exception {
        Table table = this.getTable(tableName);
        if(table == null){
            throw new Exception("不存在表 " + tableName);
        }
        table.DeleteIndex(indexName);
    }

    List<IndexXMLBean> getIndex(String tableName) throws Exception{
        Table table = this.getTable(tableName);
        if(table == null){
            throw new Exception("不存在表 " + tableName);
        }
        int size = (int)table.getIndexes().size();
        List<IndexXMLBean> iii = new ArrayList<>((int)size);
        for(int i = 0 ; i < size ; i ++){
            String xml = table.getIndexes().get(i);
            IndexXMLBean bean = IndexXMLBean.fromXML(xml.getBytes("utf-8"));
            iii.add(bean);
        }
        return iii;
    }
    
    
    Table getTable(String tableName){
       try{
            Table table = geodatabase.openTable("\\" + tableName);
            return table;
       }catch(Exception e){
            return null;
       }
    }
    
    void closeTable(Table table){
        geodatabase.closeTable(table);
        table.delete();
    }
    
    void createtable(TableSchemaBean tableSchemaBean) throws Exception{
     
       
        FGDBTableBuilder FGDBTableBuilder = new FGDBTableBuilder(tableSchemaBean);
        
        
        this.geodatabase.createTable(FGDBTableBuilder.buildCreateTableXML(), "");
        
        List<IndexXMLBean> indexXMLBeanList = this.getIndex(tableSchemaBean.getTableName());
        for(IndexXMLBean indexXMLBean : indexXMLBeanList){
            if("esriFieldTypeGeometry".equalsIgnoreCase(indexXMLBean.getFields().get(0).getType())){
         
                this.dropIndex(tableSchemaBean.getTableName(), indexXMLBean.getName());
            }
        }
        
        FGDBJNIWrapper.CloseGeodatabase(this.geodatabase);
        this.geodatabase.delete();
        this.geodatabase = null;
        
       
        /*FGDBTableBuilder tableHelper = FGDBTableBuilder.newTable(tableSchemaBean);
        try{
            this.geodatabase.createTable(tableHelper.buildAsString(), "");
        }catch(Exception e){
            UException.printStackTrace(e);
        }*/
    }
    
    void dropTable(String tableName){
        Table table = this.getTable(tableName);
        if(table != null){
           this.closeTable(table);
           geodatabase.Delete("\\" + tableName, "Table");
        }
    }
    
    void createIndex(String tableName,IIndex index) throws Exception{
        Table table = this.getTable(tableName);
        if(table == null){
            throw new Exception("不存在表 " + tableName);
        }
        IndexDef indexDef = new IndexDef(index.getName(),String.join(",", index.getColnames()),index.getUnique());
    //    table.setLoadOnlyMode(true);
     //   table.setWriteLock();
        table.AddIndex(indexDef);
    //    table.freeWriteLock();
       // table.getIndexes().get(0);
    }
    
    
    
    void delete(String tableName,String idFieldName,String where) throws Exception{
        Table table = this.getTable(tableName);
        if(table == null){
            throw new Exception("不存在表 " + tableName);
        }
        try{
            EnumRows enumRows = table.search(idFieldName, where, true);
            table.setWriteLock();
            Row row = null;
            while(true){
                row = enumRows.next();
                if(row == null){
                    break;
                }
                table.deleteRow(row);
            }
            table.freeWriteLock();
            row.delete();
            enumRows.delete();
        }finally{
            this.closeTable(table);
        }
    }
    
    int insert(String tableName,String[] fields,Type[] types,Object[] objects) throws Exception{
        Table table = this.getTable(tableName);
        if(table == null){
            throw new Exception("不存在表 " + tableName);
        }
        int id;
        try{
            table.setWriteLock();
            id = this._insert(table, fields, types,objects,true );
            table.freeWriteLock();
        }finally{
            this.closeTable(table);
        }
        return id;
    }
    
    
    int _insert(Table table,String[] fields,Type[] types,Object[] objects,Boolean needReturn) throws Exception{
        Row row = table.createRowObject();
        for(int i = 0 ; i < fields.length ; i ++){
            Type type = types[i];
            Object object = objects[i];
            String fieldName = fields[i];
            FGDBResourcesDataInput.INSATNCE.input(row, type, object, fieldName);
        }
        table.insertRow(row);
        row.delete();
        if(needReturn){
            return row.getOid();
        }else{
            return 0;
        }
    }
    
    void update(String tableName,String[] fields,Object[] objects,Type[] types){
        
    }
    
    
    
    void insertBatch(String tableName,String[] fields,Type[] types,List<Object[]> objectsList) throws Exception{
       // if(this.table == null){
            this.table = this.getTable(tableName);
      //  }
        if(table == null){
            throw new Exception("不存在表 " + tableName);
        }
        long a1 = System.currentTimeMillis();
        try{
         /*   if(!loadOnlyMode){
               
                loadOnlyMode = true;
            }*/
       
           // table.setLoadOnlyMode(true);
            table.setWriteLock();
            
            for(Object[] objects : objectsList){
                this._insert(table, fields, types, objects,false);
            }
            table.freeWriteLock();
           
            //System.out.println("_______" + (System.currentTimeMillis() - a1));
        }finally{
            this.closeTable(table);
        }
    }
    
    public static void create(String fileName){
    	FGDBLibrariesInitializer.initLibraries();

        
        FGDBJNIWrapper.createGeodatabase(fileName);
        
    }

    /**
     * 
     */
    public void close() {
		if(this.geodatabase != null){
		    FGDBJNIWrapper.CloseGeodatabase(this.geodatabase);
		    this.geodatabase.delete();
		    
		}
		this.lock.lock();
	    this.isDestroy = true;
	    this.notEmpty.signal();
	    this.lock.unlock();
        
    }
    
   /* public static FGDB_ESRIShell  createGDB(){
        
    }
    
    
    public static FGDB_ESRIShell getShell(){
        
    }*/
    
    
    
    
    
    
    
    
}
