/**
　 * <p>Title: FGDBDataSourceOperator.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datasource.fgdb.operate;

import java.util.List;
import java.util.concurrent.ExecutionException;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.IDataSourceOperator;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.Cmd.CMD_TYPE;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datasource.fgdb.FGDB_ESRIShell;

/**
 * @author matt
 *
 */
@ATableOperator(name = "fgdb",type = DATA_SOURCE_TYPE.fgdb)
public class FGDBDataSourceOperator implements IDataSourceOperator<FGDBDataSource> {

   
    
    
    @Override
    public String[] tables(FGDBDataSource pool) {
        // TODO Auto-generated method stub
        return pool.connection().getGDALShell().getTables();
    }

   
    @Override
    public void drop(FGDBDataSource pool, String tableName) {
        // TODO Auto-generated method stub
        FGDB_ESRIShell shell = pool.connection().getESRIShell();
        Cmd cmd = new Cmd(CMD_TYPE.droptable,tableName);
        shell.addCmd(cmd);
        try {
            cmd.getPromise().get();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new DataAccessException(e);
        }
        
    }

   
    @Override
    public void createTableBySchemaBean(FGDBDataSource pool, TableSchemaBean tableSchemaBean) {
        // TODO Auto-generated method stub
        FGDB_ESRIShell shell = pool.connection().getESRIShell();
        Cmd cmd = new Cmd(CMD_TYPE.createtable,tableSchemaBean);
        shell.addCmd(cmd);
        try {
            cmd.getPromise().get();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new DataAccessException(e);
        }
    }

   
    @Override
    public List<String> schemas(FGDBDataSource pool) {
        // TODO Auto-generated method stub
        return null;
    }

   
    @Override
    public Boolean hasSchema(FGDBDataSource pool, String schema) {
        // TODO Auto-generated method stub
        return true;
    }

   
    @Override
    public Boolean hasTable(FGDBDataSource pool, String tableName) {
        // TODO Auto-generated method stub
        return  pool.connection().getGDALShell().hasTable(tableName);
    }

   

}
