/**
　 * <p>Title: AbstractFGDBTransformer.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年7月1日
　 * @version 1.0
*/
package com.northpool.resources.datatable.fgdb;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Layer;

import com.northpool.exception.UException;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.SpatialInfo;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;
import com.northpool.type.TypeFGDBGeometry;

/**
 * @author matt
 *
 */
public abstract class AbstractFGDBTransformer<T> {
    
//    LinkedHashMap<String, Type> createTypeMap(final Layer layer,Map<String, Type> typeMap,final IDialect dialect) throws DataAccessException{
//       
//        try {
//            int columnCount = layer.GetLayerDefn().GetFieldCount();
//            if(typeMap == null){
//                typeMap = new LinkedHashMap<String, Type>();
//            }
//            LinkedHashMap<String, Type> newTypeMap = new LinkedHashMap<String, Type>();
//            for (int i = 0; i <= columnCount; i++) {
//                String name = layer.GetLayerDefn().GetFieldDefn(i).GetName();
//                String type = layer.GetLayerDefn().GetFieldDefn(i).GetTypeName();
//               // String name = rsmd.getColumnLabel(i);
//                if(typeMap.get(name) == null){
//                    Type t = dialect.getTypeByName(type);
//                    newTypeMap.put(name, t);
//                }
//            }   
//            return newTypeMap;
//        } catch (Exception e) {
//            // TODO Auto-generated catch block
//            UException.printStackTrace(e);
//            throw new DataAccessException(e);
//        }
//    }
    
    LinkedHashMap<String, Type> createTypeLinkedMap(final Layer layer, Map<String, Type> typeMap,final IDialect dialect,final String[] queryFieldArray, String spatialFieldName) throws DataAccessException{
        LinkedHashMap<String, Type> typeLink = new LinkedHashMap<>();
        try {
            int columnCount = layer.GetLayerDefn().GetFieldCount();
            if(typeMap == null){
                typeMap = new HashMap<String, Type>();
            }
            LinkedHashMap<String, Type> newTypeMap = new LinkedHashMap<String, Type>();
            for (int i = 0; i < columnCount; i++) {
                String name = layer.GetLayerDefn().GetFieldDefn(i).GetName();
                String typeName = layer.GetLayerDefn().GetFieldDefn(i).GetTypeName();
                Type type = typeMap.get(typeName);
                if(type == null){
                    type = dialect.getTypeByName(typeName);
                }
                newTypeMap.put(name, type);
            }
            for(int i = 0 ; i < queryFieldArray.length ; i ++){
                String fieldName =  queryFieldArray[i]; 
                Type type = newTypeMap.get(fieldName);
                if(type == null){
                    //空间字段没有在查询结果中,需要加上
                    if(fieldName.equals(spatialFieldName)){
                        typeLink.put(spatialFieldName, TypeFGDBGeometry.INSTANCE);
                    }else{
                    
                        throw new RuntimeException("查询结果找不到字段 " + fieldName + " 的对应类型");
                    }
                }else{
                    typeLink.put(fieldName, type);
                }
            }
            return typeLink;
        } catch (Exception e) {
            // TODO Auto-generated catch block
            UException.printStackTrace(e);
            throw new DataAccessException(e);
        }
    }
    
    
    
    
    abstract protected ResultSetMapping<T,Cursor> getMapping();
    
    public List<T> extractData(FGDBDialect dialect, Layer rs, Map<String, Type> typeMap)throws DataAccessException {

        return null;
 
    }
    
    /*private Cursor createCursor(FGDBScrollStatement scrollStatement){
        ITable table = scrollStatement.getTable();
        String[] fields = scrollStatement.getQueryFields();
        boolean needSpatialData = false;
        String spatialFieldName = null;
        int spatialFieldIndex = -1;
        SpatialInfo spatialInfo = table.spatialInfo();
        if(spatialInfo != null){
            spatialFieldName = spatialInfo.getSpatialField();
            spatialFieldIndex = ArrayUtils.indexOf(fields, spatialFieldName);
            if(spatialFieldIndex != -1){
                needSpatialData = true;
            }
        }
        
        Cursor cursor = new Cursor(needSpatialData,spatialFieldIndex,spatialFieldName,fields);
        return cursor;
    }*/
    
    public IScroll<T> extractDataScroll(FGDBDialect dialect, Layer layer, Map<String, Type> typeMap, FGDBScrollStatement scrollStatement) throws DataAccessException {
        int firstResult = scrollStatement.getFirstResult();
        int maxResults = scrollStatement.getMaxResults();
       
        //final Cursor cursor = this.createCursor(scrollStatement);
        final Cursor cursor = new Cursor();
        
        ResultSetMapping<T,Cursor> mapping = this.getMapping();
        
        SpatialInfo spatialInfo = scrollStatement.getTable().spatialInfo();
        String spatialFieldName = null;
        if(spatialInfo != null){
            spatialFieldName = spatialInfo.getSpatialField();
          
        }
        
        LinkedHashMap<String, Type> typeMapLink = this.createTypeLinkedMap(layer, typeMap,dialect, scrollStatement.queryFields,spatialFieldName);
        
        if(firstResult != -1){
            while(cursor.getCursorIndex() < firstResult){
                layer.GetNextFeature();
                cursor.cursorIndexGoNext();
            }
        }
        
        IScroll<T> scroll = new IScroll<T>(){
            @Override
            public boolean hasNext()  {
                try {
                    Feature feature = layer.GetNextFeature();
                    if(feature == null || cursor.getCursorIndex() == maxResults){
                        return false;
                    }else{
                        cursor.cursorIndexGoNext();
                        cursor.setValue(feature);
                        return true;
                    }
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    UException.printStackTrace(e);
                    throw new DataAccessException(e);
                }
            }
   
            @Override
            public T next()  {
                T t = mapping.mapping(cursor,typeMapLink,dialect);
                return t;
            }
   
            @Override
            public void close() throws IOException {
                layer.delete();
            } 
        };
        
        return scroll;
    }
    
    public class Cursor{
        int cursorIndex = 0;
        Feature value;
      /*  boolean needSpatialData = true;
        int spatialFieldIndex;
        String spatialFieldName;
        //这里面包含空间字段
        String[] queryFieldArray;*/
        
        
        
        public Cursor(/*boolean needSpatialData,int spatialFieldIndex,String spatialFieldName,String[] queryFieldArray*/){
          /*  this.needSpatialData = needSpatialData;
            this.spatialFieldIndex = spatialFieldIndex;
            this.spatialFieldName = spatialFieldName;
            this.queryFieldArray = queryFieldArray;*/
        }
        
        public int getCursorIndex() {
            return cursorIndex;
        }
        
        public void setValue(Feature value) {
            this.value = value;
        }

        public Feature getValue() {
            return value;
        }
        public void cursorIndexGoNext(){
            cursorIndex ++;
        }

       /* public boolean needSpatialData() {
            return needSpatialData;
        }

        public int getSpatialFieldIndex() {
            return spatialFieldIndex;
        }

        public String getSpatialFieldName() {
            return spatialFieldName;
        }

        public String[] getQueryFieldArray() {
            return queryFieldArray;
        }*/
       
        
    }
}
