/**
　 * <p>Title: MapFGDBTransformer.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月29日
　 * @version 1.0
*/
package com.northpool.resources.datatable.fgdb;

import java.util.*;

import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.TypeFGDBGeometry;
import org.gdal.ogr.Feature;

import com.northpool.type.Type;



/**
 * @author matt
 *
 */
public class MapFGDBTransformer extends AbstractFGDBTransformer implements IFGDBTransformer<Map<String,Object>> {


    @Override
    protected ResultSetMapping getMapping() {
        return new ResultSetMapping<Map<String, Object>,Cursor>(){

            @Override
            public Map<String, Object> mapping(Cursor cursor, LinkedHashMap<String, Type> typeLink, final IDialect dialect) {

                Feature feature = cursor.getValue();

                IResourcesDataOutput<Feature,Integer> output = dialect.getResourcesDataOutput();

                Map<String, Object> map = new HashMap<>(typeLink.size());

                Iterator<Map.Entry<String,Type>> iterator = typeLink.entrySet().iterator();
                int indexInQueryFieldArray = 0;
                //因为空间字段不在导出字段中,所以单独需要一个index
                int indexInDataOutput = 0;
                while(iterator.hasNext()){
                    Map.Entry<String, Type> entry = iterator.next();
                    Type type = entry.getValue();
                    Object object = null;
                    if(type.getEnum() != TypeFGDBGeometry.INSTANCE.getEnum()){
                        object = output.output(feature, type, indexInDataOutput);
                        indexInDataOutput ++;
                    }else{
                        object = output.output(feature, type, null);
                    }
                    map.put(entry.getKey(), object);
                    indexInQueryFieldArray ++;

                }
                feature.delete();
                return map;

            }


        };
    }
}
