/**
　 * <p>Title: FGDBOperator.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datatable.fgdb.operate;


import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.northpool.exception.NotSupport;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.fgdb.Cmd;
import com.northpool.resources.datasource.fgdb.FGDBDataSource;
import com.northpool.resources.datasource.fgdb.FGDB_GDALShell;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.fgdb.FGBDTable;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.fgdb.FGDBDialect;
import com.northpool.resources.dialect.fgdb.FieldXmlBean;
import com.northpool.resources.dialect.fgdb.IndexXMLBean;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.spatial.geofeature.GeoBuffer;

/**
 * @author matt
 *
 */
@ATableOperator(name = "fgdb",type = DATA_SOURCE_TYPE.fgdb)
public class FGDBOperator extends AbstractTableOperator implements ITableOperator {

   
    FGDBDataSource fGDBDataSource;
    
    FGDB_GDALShell gdalShell;
    
    Logger logger = LoggerFactory.getLogger(FGDBOperator.class);
    @Override
    public String mark() {
        // TODO Auto-generated method stub
        return new StringBuilder().append(this.tableName).append("@").append(this.dataSource.mark()).toString();
    }

    protected CompletableFuture<Object> getEmptyPromise(){
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() ->{
            return null;
        });
        return promise; 
    }
    
   
    @Override
    public CompletableFuture<Object> createPK(String colname) {
        // TODO Auto-generated method stub
        logger.info("fgdb 不支持创建主键");
        return getEmptyPromise();
    }

   
    
    
    @Override
    public CompletableFuture<Object> _createIndex(Boolean unique, String... colnames) {
        IIndex index = new Index();
        index.setName(this.createIndexName(colnames));
        index.setUnique(unique);
        
        for(String colname : colnames){
            index.addColname(colname);
        }
            
        index.setSpatial(true);
        index.setUnique(true);
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.createindex,this.tableName,index);
        fGDBDataSource.connection().getESRIShell().addCmd(cmd);
        CompletableFuture<Object> promise = cmd.getPromise();
        promise.thenAccept(object -> {
            this.addToIndexMap(index.getName(), index);
            
        });
        
        return promise;

    }

   
    @Override
    public CompletableFuture<Object> dropIndex(String indexName) {
        // TODO Auto-generated method stub
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.droptable,this.tableName,indexName);
        fGDBDataSource.connection().getESRIShell().addCmd(cmd);
        return cmd.getPromise();
    }

   
    @Override
    public CompletableFuture<Object> dropPK() {
        // TODO Auto-generated method stub
        logger.info("fgdb 不支持删除主键");
        return getEmptyPromise();
    }

    
    @Override
    protected Object[] getSpatialInfo(String colunmName) throws Exception {
        // TODO Auto-generated method stub
        //无需实现
        return null;

    }

    
    @Override
    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws Exception {
       // TODO Auto-generated method stub
      //无需实现
        return null; 
    }

    @Override
    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        // TODO Auto-generated method stub
        this.tableName = tableName;
        this.dataSource = (FGDBDataSource)dataSource;
        this.fGDBDataSource = (FGDBDataSource)dataSource;
        this.gdalShell = fGDBDataSource.connection().getGDALShell();
        
        this.dialect = FGDBDialect.INSTANCE;    

        this.buildTableInfo(this.tableName);
        /*if(this.hasSpatialColumn()){
            this.buildSpatialColumnInfo();
        }*/
        
        
    }
    
    protected void buildTableInfo(String tableName) throws TableNotFoundException {
        // TODO Auto-generated method stub
        this.getTableInfo(tableName);
        this.buildColumns(tableName);
        this.buildIndexInfo(tableName);
    }
    
    
    protected void getTableInfo(String tableName) throws TableNotFoundException{
        this.isView = false;
        this.tableRemarks = this.gdalShell.geTableRemarks(tableName);
    }

    protected void buildColumns(String tableName) throws TableNotFoundException{
        this.columnMap = this.gdalShell.getColumnMap(tableName);
    }
    
    protected List<Index> getIndexInfo(String tableName){
        FGDBDataSource gdbDataSource = (FGDBDataSource)dataSource;
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.getIndex,tableName);
        gdbDataSource.connection().getESRIShell().addCmd(cmd);
        try {
            List<IndexXMLBean> indexBeanList = (List<IndexXMLBean>)cmd.getPromise().get();
            List<Index> indexList = new ArrayList<>(indexBeanList.size());
            for(IndexXMLBean indexBean : indexBeanList){
                Index index = new Index();
                index.setName(indexBean.getName());
                index.setUnique(indexBean.getIsUnique());
                if(indexBean.getFields().size() == 1){
                    if(FGDBDialect.KEY_WORD_SERIAL.equalsIgnoreCase(indexBean.getFields().get(0).getType())){
                        index.setIsPK(true);
                    }
                    if(FGDBDialect.KEY__WORD_GEOMETRY.equalsIgnoreCase(indexBean.getFields().get(0).getType())){
                        index.setSpatial(true);
                    }
                }
                for(FieldXmlBean field : indexBean.getFields()){
                    index.addColname(field.getName());
                }
                indexList.add(index);
            }
            
            return indexList;
            
        } catch (InterruptedException | ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
    
    
    protected void buildIndexInfo(String tableName) throws TableNotFoundException{
        List<Index> indexList = this.getIndexInfo(tableName);
        for(Index index : indexList){
            this.indexMap.put(index.getName(), index);
        }
    }
    

 
    @SuppressWarnings("unchecked")
    @Override
    protected AbstractTable _getTable() {
        // TODO Auto-generated method stub
        return new FGBDTable();
    }


    @Override
    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        // TODO Auto-generated method stub
       
        IIndex index = new Index();
        index.setName(this.createSpatialIndexName(colname));
        index.addColname(colname);
        index.setSpatial(true);
        index.setUnique(true);
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.createindex,this.tableName,index);
        fGDBDataSource.connection().getESRIShell().addCmd(cmd);
        CompletableFuture<Object> promise = cmd.getPromise();
        promise.thenAccept(object -> {
            this.addToIndexMap(index.getName(), index);
            
        });
        
        return promise;
    }

   

   

   

}
