/**
　 * <p>Title: PostgresFieldRefDialect.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年3月31日
　 * @version 1.0
*/
package com.northpool.resources.dialect.fgdb;


import org.fgdbapi.thindriver.xml.EsriFieldType;
import org.fgdbapi.thindriver.xml.EsriGeometryType;
import org.fgdbapi.thindriver.xml.Field;
import org.fgdbapi.thindriver.xml.GeometryDef;
import org.fgdbapi.thindriver.xml.SpatialReference;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.fgdb.EsriTypeUtils;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;

/**
 * @author matt
 *
 */
public class FGDBFieldRefDialect implements ICreateTableFieldRefDialect<FGDBTableBuilder,Field> {

    public static final FGDBFieldRefDialect INSTANCE = new FGDBFieldRefDialect();
    
    Field createField(ColumnBean columnBean){
        Field field = new Field();
        field.setName(columnBean.getColumnName());
        field.setModelName(columnBean.getRemarks() == null ? "" : columnBean.getRemarks());
        if(columnBean.getNullable()){
            field.setIsNullable(true);
        }else{
            field.setIsNullable(false);
        }
        if(columnBean.getIsSpatial()){
            field.setRequired(true);
            field.setIsNullable(false);
        }
       
        field.setEditable(true);
        return field;
    }
    
    
    @Override
    public Field columnBoolean(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_SMALL_INTEGER);
        builder.addField(field);  
        return field;
    }

    
    @Override
    public Field columnBigDecimal(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
        field.setLength(8);
        builder.addField(field);   
        return field;
    }

   
    @Override
    public Field columnBytes(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_BLOB);
        builder.addField(field); 
        return field;
    }

   
    @Override
    public Field columnDouble(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_DOUBLE);
        field.setLength(8);
        builder.addField(field); 
        return field;
    }

   
    @Override
    public Field columnGeometry(FGDBTableBuilder builder, ColumnBean columnBean) {
        
        Field field = this.createField(columnBean);
        EsriGeometryType geomType = EsriTypeUtils.geomType2EsriGeometryType(columnBean.getGeoType());;
        SpatialReference gcs = EsriTypeUtils.getSpatialReferenceBySRID(columnBean.getSrid());
        GeometryDef geom = new GeometryDef();
        geom.setGeometryType(geomType);
        geom.setSpatialReference(gcs);
        geom.setGridSize0((double) 0);
        geom.setHasM(false);
        geom.setHasZ(false);
        field.setGeometryDef(geom);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_GEOMETRY);
        builder.addField(field); 
        return field;
    }

   
    @Override
    public Field columnInteger(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
        field.setLength(4);
        builder.addField(field);   
        return field;
    }

   
    @Override
    public Field columnLong(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_INTEGER);
        field.setLength(8);
        builder.addField(field); 
        return field;
    }

   
    @Override
    public Field columnString(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_STRING);
        if(columnBean.getColumnSize() != null){
            field.setLength(columnBean.getColumnSize());
        }
        builder.addField(field);    
        return field;
    }

   
    @Override
    public Field columnTimestamp(FGDBTableBuilder builder, ColumnBean columnBean) {
        Field field = this.createField(columnBean);
        field.setType(EsriFieldType.ESRI_FIELD_TYPE_DATE);
        builder.addField(field);   
        return field;
    }

   
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        // TODO Auto-generated method stub
        return DATA_SOURCE_TYPE.fgdb;
    }

    
    

 
 
  
  

}
