/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.hbase.operate;

import com.geoway.atlas.gis.toolkit.meta.api.AtlasGisToolkitApi;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.hbase.connection.HbaseConnection;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.hbase.HbaseTable;
import com.northpool.resources.datatable.hbase.operate.HbaseColumn;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.spatial.geofeature.GeoBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

@ATableOperator(name="hbase", type=Constants.DATA_SOURCE_TYPE.hbase)
public class HbaseTableOperator
extends AbstractTableOperator
implements ITableOperator {
    private static final String HBASE_DATA_FORMAT = "gw-vector";
    private HbaseConnection hbaseConnection;
    private SimpleFeatureType simpleFeatureType;

    public String mark() {
        return this.tableName + "@" + this.dataSource.mark();
    }

    protected CompletableFuture<Object> getEmptyPromise() {
        return CompletableFuture.supplyAsync(() -> null);
    }

    public CompletableFuture<Object> createPK(String colname) {
        this.logger.info(this.dataSource.getDataSourceType().name() + " \u4e0d\u652f\u6301\u521b\u5efa\u4e3b\u952e");
        return this.getEmptyPromise();
    }

    protected CompletableFuture<Object> _createIndex(Boolean unique, String ... colnames) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "\u4e0d\u652f\u6301\u521b\u5efa\u7d22\u5f15");
    }

    public CompletableFuture<Object> dropIndex(String indexName) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "\u4e0d\u652f\u6301\u5220\u9664\u7d22\u5f15");
    }

    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "\u4e0d\u652f\u6301\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15");
    }

    public CompletableFuture<Object> dropPK() {
        this.logger.info(this.dataSource.getDataSourceType().name() + " \u4e0d\u652f\u6301\u5220\u9664\u4e3b\u952e");
        return this.getEmptyPromise();
    }

    protected Object[] getSpatialInfo(String colunmName) {
        return null;
    }

    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws Exception {
        return null;
    }

    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        this.tableName = tableName;
        this.dataSource = dataSource;
        this.hbaseConnection = (HbaseConnection)dataSource.connection();
        try {
            this.simpleFeatureType = AtlasGisToolkitApi.getSimpleFeatureType((String)HBASE_DATA_FORMAT, (String)this.hbaseConnection.getUrl(), (String)this.hbaseConnection.getNamespace(), (String)tableName);
        }
        catch (Exception e) {
            this.logger.error("HbaseSDK\u8c03\u7528\u51fa\u9519" + e.getMessage());
        }
        this.buildTableInfo(this.tableName);
    }

    protected void buildTableInfo(String tableName) {
        this.isView = false;
        this.tableRemarks = tableName;
        this.buildColumns();
        this.buildIndexInfo();
    }

    protected void buildColumns() {
        List attributeDescriptors = this.simpleFeatureType.getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            HbaseColumn column = new HbaseColumn(attributeDescriptor.getLocalName(), null, null, attributeDescriptor.getType().getName().getLocalPart().toLowerCase(), attributeDescriptor.isNillable(), null, null, null);
            this.columnMap.put(attributeDescriptor.getLocalName(), column);
        }
        HbaseColumn idColumn = HbaseColumn.createIdColumn("FID");
        this.columnMap.put("FID", idColumn);
        String geometryColumnName = this.simpleFeatureType.getGeometryDescriptor().getName().getLocalPart();
        if (StringUtils.isEmpty((CharSequence)geometryColumnName)) {
            geometryColumnName = "_hbase_geometry_";
        }
        HbaseColumn geometryColumn = HbaseColumn.createSpatialColumn(geometryColumnName, this.getSrid(), this.getGeometryType());
        this.columnMap.put(geometryColumnName, geometryColumn);
    }

    private Integer getSrid() {
        return AtlasGisToolkitApi.getCoordinateReferenceSystem((SimpleFeatureType)this.simpleFeatureType).getSrid();
    }

    private Integer getGeometryType() {
        return AtlasGisToolkitApi.getGeometryType((SimpleFeatureType)this.simpleFeatureType) >> 2;
    }

    protected void buildIndexInfo() {
        String geometryColumn = this.simpleFeatureType.getGeometryDescriptor().getName().getLocalPart();
        String fidColumn = "";
        if (StringUtils.isEmpty((CharSequence)fidColumn)) {
            fidColumn = "FID";
        }
        if (StringUtils.isEmpty((CharSequence)geometryColumn)) {
            geometryColumn = "_hbase_geometry_";
        }
        Index pkIndex = new Index();
        pkIndex.setAsc("asc");
        pkIndex.setName(fidColumn + "_idx");
        pkIndex.setUnique(Boolean.valueOf(true));
        pkIndex.setIsPK(Boolean.valueOf(true));
        pkIndex.addColname(fidColumn);
        this.indexMap.put(pkIndex.getName(), pkIndex);
        Index geoIndex = new Index();
        geoIndex.setAsc("asc");
        geoIndex.setName(geometryColumn + "_spx");
        geoIndex.setUnique(Boolean.valueOf(false));
        geoIndex.addColname(geometryColumn);
        geoIndex.isSpatial(Boolean.valueOf(true));
        this.indexMap.put(geoIndex.getName(), geoIndex);
    }

    protected AbstractTable _getTable() {
        return new HbaseTable();
    }

    public Integer getIndex(String fieldName) {
        List attributeDescriptors = this.simpleFeatureType.getAttributeDescriptors();
        for (int i = 0; i < attributeDescriptors.size(); ++i) {
            if (!((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }
}

