/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.hbase;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.hbase.connection.HbaseConnection;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import java.sql.ResultSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@ADataSource(name="hbase", types="hbase")
public class HbaseDatasource
implements IDataSource {
    protected String url;
    protected String namespace;
    protected String id;
    protected HbaseConnection hbaseConnection;
    protected String version;

    HbaseDatasource() {
    }

    public HbaseDatasource(String url, String id) {
        this.url = StringUtils.substringBeforeLast((String)url, (String)"/");
        this.namespace = StringUtils.substringAfterLast((String)url, (String)"/");
        this.id = id;
        this.hbaseConnection = new HbaseConnection(this.url, this.namespace);
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toJson() {
        return JSON.toJSON((Object)this).toString();
    }

    public String mark() {
        return this.url;
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.hbase;
    }

    public void testConnection() throws Exception {
        throw new UnsupportedOperationException("testConnection");
    }

    public HbaseConnection connection() throws Exception {
        if (null == this.hbaseConnection) {
            this.hbaseConnection = new HbaseConnection(this.url, this.namespace);
        }
        return this.hbaseConnection;
    }

    public void resetConnection() {
        throw new UnsupportedOperationException("resetConnection");
    }

    public void destory() {
        throw new UnsupportedOperationException("destory");
    }

    public ITableOperator getTableOperator(String tableName) throws Exception {
        return ITableOperator.getTableOperator((IDataSource)this, (String)tableName, (Map)null);
    }

    public ITable getTable(String tableName) throws Exception {
        return this.getTableBuilder(tableName).getTable();
    }

    public ITableOperator getTableBuilder(String tableName) throws Exception {
        return ITableOperator.getTableOperator((IDataSource)this, (String)tableName, (Map)null);
    }

    public ITable getTable(String tableName, FieldEncoder fieldEncoder) throws Exception {
        return this.getTableBuilder(tableName).getTable(fieldEncoder);
    }

    public ITable getTable(String tableName, String[] selectFields) throws Exception {
        return this.getTableBuilder(tableName).getTable(selectFields);
    }

    public String[] tables() {
        throw new UnsupportedOperationException("tables");
    }

    public Boolean hasSchema(String schema) {
        throw new UnsupportedOperationException("hasSchema");
    }

    public Boolean hasTable(String tableName) {
        throw new UnsupportedOperationException("hasTable");
    }

    public void drop(String tableName) {
        throw new UnsupportedOperationException("drop");
    }

    public void createTableBySchemaBean(TableSchemaBean schemaBean) {
    }

    public ResultSet getSqlQuery(String sql) {
        return null;
    }

    public Boolean executeSqlCommand(String sql) {
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

