/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.hbase.operate;

import com.northpool.resources.datatable.db.operate.column.AbstractDBColumn;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.hbase.HbaseSQLDialect;
import com.northpool.spatial.Constants;

public class HbaseColumn
extends AbstractDBColumn
implements IColumn {
    public HbaseColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName, Boolean nullable, String defaultValue, String remarks, IDialect dialect) {
        super(columnName, columnSize, digits, columnTypeName, nullable, defaultValue, remarks, (IDialect)HbaseSQLDialect.INSTANCE);
    }

    protected void initAttType() {
        this.type = this.dialect.getTypeByName(this.columnTypeName);
        if ("geometry".equals(this.columnTypeName)) {
            this.isSpatial = true;
        }
    }

    public Constants.SPATIAL_TYPE getSpatialType() {
        return Constants.SPATIAL_TYPE.wkt;
    }

    public static HbaseColumn createIdColumn(String name) {
        HbaseColumn column = new HbaseColumn(name, null, null, "String", false, null, "\u4e3b\u952e", (IDialect)HbaseSQLDialect.INSTANCE);
        column.setIsPK(true);
        FieldDefaultValueBean fieldDefaultValueBean = new FieldDefaultValueBean();
        fieldDefaultValueBean.setType(FieldDefaultValueBean.VALUE_TYPE.serial);
        column.setFieldDefaultValue(fieldDefaultValueBean);
        column.setIsSerial(true);
        return column;
    }

    public static HbaseColumn createSpatialColumn(String name, Integer srid, Integer hbaseGeometryType) {
        HbaseColumn column = new HbaseColumn(name, null, null, "geometry", false, null, "\u7a7a\u95f4\u5b57\u6bb5", (IDialect)HbaseSQLDialect.INSTANCE);
        column.setIsSpatial(true);
        column.setSRID(srid);
        column.setGeoType(HbaseColumn.hbaseGeometryType2GeoType(hbaseGeometryType));
        return column;
    }

    private static Constants.GEO_TYPE hbaseGeometryType2GeoType(int hbaseGeometryType) {
        switch (hbaseGeometryType) {
            case 0: {
                return Constants.GEO_TYPE.MULTIPOINT;
            }
            case 1: {
                return Constants.GEO_TYPE.MULTILINESTRING;
            }
            case 2: {
                return Constants.GEO_TYPE.MULTIPOLYGON;
            }
        }
        throw new RuntimeException("\u627e\u4e0d\u5230hbaseGeometryType:" + hbaseGeometryType + "\u4e0eGEO_TYPE\u7684\u6620\u5c04\u5173\u7cfb");
    }
}

