/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.hbase;

import com.northpool.exception.NotSupport;
import com.northpool.resources.Constants;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ADialect;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.function.Function;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.type.Type;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypePostGisGeometry;
import com.northpool.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.locationtech.jts.geom.Geometry;

@ADialect(name="hbase", type=Constants.DATA_SOURCE_TYPE.hbase)
public class HbaseSQLDialect
extends AbstractSQLDialect
implements ISQLDialect {
    public static final HbaseSQLDialect INSTANCE = new HbaseSQLDialect();

    public HbaseSQLDialect() {
        this.name = Constants.DATA_SOURCE_TYPE.hbase.name();
    }

    public String getSelfDesc() {
        return "hbase \u65b9\u8a00";
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.hbase;
    }

    protected void registerTypes() {
        this.registerType((Type)Types.INTEGER, new String[]{"serial", "int", "int2", "int4", "integer", "short"});
        this.registerClassType((Type)Types.INTEGER, new Class[]{Integer.class, Short.class});
        this.registerType((Type)Types.STRING, new String[]{"String", "string"});
        this.registerClassType((Type)Types.STRING, new Class[]{String.class});
        this.registerType((Type)Types.BIGDECIMAL, new String[]{"numeric", "number"});
        this.registerClassType((Type)Types.BIGDECIMAL, new Class[]{BigDecimal.class, BigInteger.class});
        this.registerType((Type)Types.TIME_STAMP, new String[]{"timestamp", "dateTime", "Date"});
        this.registerClassType((Type)Types.TIME_STAMP, new Class[]{Date.class});
        this.registerType((Type)Types.BOOLEAN, new String[]{"boolean", "bool"});
        this.registerClassType((Type)Types.BOOLEAN, new Class[]{Boolean.class});
        this.registerType((Type)Types.LONG, new String[]{"long", "int8"});
        this.registerClassType((Type)Types.LONG, new Class[]{Long.class});
        this.registerType((Type)TypePostGisGeometry.INSTANCE, new String[]{"geometry"});
        this.registerClassType((Type)TypePostGisGeometry.INSTANCE, new Class[]{Geometry.class, GeoBuffer.class});
        this.registerType((Type)Types.DOUBLE, new String[]{"float", "float4", "float8", "double"});
        this.registerClassType((Type)Types.DOUBLE, new Class[]{Double.class, Float.class});
        this.registerType((Type)TypeBytes.INSTANCE, new String[]{"Binary", "bytea", "byte[]"});
        this.registerClassType((Type)TypeBytes.INSTANCE, new Class[]{byte[].class});
    }

    protected void registerFunctions() {
        Type[] typeIn = new Type[]{TypePostGisGeometry.INSTANCE, TypePostGisGeometry.INSTANCE};
        this.registerFunction("intersects", (Function)new SQLSpatialRelateFunction("st_intersects", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("mbr_intersects", (Function)new SpatialFilterExpression((Type)Types.BOOLEAN, typeIn));
    }

    public boolean isColumnSerial(ColumnBean columnBean, String columnTypeName) {
        return false;
    }

    public <INPUT, INDEX_OR_LABEL> IResourcesDataInput<INPUT, INDEX_OR_LABEL> getResourcesDataDataInput() {
        throw new NotSupport();
    }

    public <OUTPUT, INDEX_OR_LABEL> IResourcesDataOutput<OUTPUT, INDEX_OR_LABEL> getResourcesDataOutput() {
        throw new NotSupport();
    }

    public <TABLE_BUILD, FIELD> ICreateTableFieldRefDialect<TABLE_BUILD, FIELD> getCreateTableFieldRefDialect() {
        throw new NotSupport();
    }

    public Boolean markForTableNameAndColumnName() {
        return true;
    }

    public String getJDBCDriver() {
        throw new NotSupport();
    }

    public String createConnectUrl(String url) {
        throw new NotSupport();
    }

    public String getDefaultSchema() {
        throw new NotSupport();
    }

    public Boolean isFieldSerial(String columnTypeName) {
        return null;
    }

    public String createSequenceName(String schema, String tableName, String fieldName) {
        throw new NotSupport();
    }

    public String hasSequenceSql(String sequenceName) {
        throw new NotSupport();
    }

    public String getCreateSequenceSQL(String sequenceName) {
        throw new NotSupport();
    }

    protected boolean defaultValueIsSequence(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsFuntion(String columnTypeName, String defaultValue) {
        return false;
    }

    protected boolean defaultValueIsNowDate(String columnTypeName, String defaultValue) {
        throw new NotSupport();
    }
}

