/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.hbasemeta;

import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.gis.toolkit.meta.api.AtlasGisToolkitApi;
import com.geoway.atlas.gis.toolkit.meta.api.AtlasHbaseDataApi;
import com.geoway.atlas.gis.toolkit.meta.bean.hbase.HbaseReader;
import com.northpool.resources.datasource.hbase.connection.HbaseConnection;
import com.northpool.resources.hbasemeta.ColumnMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class HBaseTableMeta {
    private static GeometryFactory factory = new GeometryFactory();

    public static Boolean exists(HbaseConnection conn, String tableName) {
        try {
            SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
            return StringUtils.isNotBlank((CharSequence)sft.getTypeName());
        }
        catch (Exception ex) {
            if (ex instanceof NotFoundException) {
                return false;
            }
            throw ex;
        }
    }

    public static Integer getSRID(HbaseConnection conn, String tableName) {
        SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        return AtlasGisToolkitApi.getCoordinateReferenceSystem((SimpleFeatureType)sft).getSrid();
    }

    public static String getExtentWKT(HbaseConnection conn, String tableName) {
        SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        Envelope extent = AtlasGisToolkitApi.getEnvelope((SimpleFeatureType)sft);
        Geometry geometry = factory.toGeometry(extent);
        return geometry.toText();
    }

    public static Integer getGeometryType(HbaseConnection conn, String tableName) {
        SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        return (int)AtlasGisToolkitApi.getGeometryType((SimpleFeatureType)sft);
    }

    public static Long count(HbaseConnection conn, String tableName) {
        SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        return AtlasGisToolkitApi.getCount((SimpleFeatureType)sft);
    }

    public static List<ColumnMeta> getFields(HbaseConnection conn, String tableName) throws Exception {
        SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        int srid = AtlasGisToolkitApi.getCoordinateReferenceSystem((SimpleFeatureType)sft).getSrid();
        int geometryTypeInt = AtlasGisToolkitApi.getGeometryType((SimpleFeatureType)sft) >> 2;
        String geometryColumnName = sft.getGeometryDescriptor().getLocalName();
        ArrayList<ColumnMeta> tableColumns = new ArrayList<ColumnMeta>();
        ColumnMeta idColumn = new ColumnMeta();
        idColumn.setName("FID");
        idColumn.setType("string");
        idColumn.setKey(true);
        tableColumns.add(idColumn);
        List attributeDescriptors = sft.getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            ColumnMeta column = new ColumnMeta();
            String fieldName = attributeDescriptor.getLocalName();
            column.setName(fieldName);
            column.setType(attributeDescriptor.getType().getBinding().getSimpleName());
            if ("Geometry".equalsIgnoreCase(column.getType())) {
                column.setSrid(srid);
                column.setAlias("shape");
                if (geometryTypeInt == 0) {
                    column.setType("MULTIPOINT");
                } else if (geometryTypeInt == 1) {
                    column.setType("MULTILINESTRING");
                } else if (geometryTypeInt == 2) {
                    column.setType("MULTIPOLYGON");
                }
            }
            tableColumns.add(column);
        }
        if (StringUtils.isEmpty((CharSequence)geometryColumnName)) {
            ColumnMeta geoColumn = new ColumnMeta();
            geoColumn.setName("_hbase_geometry_");
            geoColumn.setAlias("shape");
            geoColumn.setType("geometry");
            geoColumn.setSrid(srid);
            tableColumns.add(geoColumn);
        }
        return tableColumns;
    }

    public static List<String> getTableList(HbaseConnection conn) {
        String[] featureClassNames = AtlasGisToolkitApi.getFeatureClassNames((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace());
        return Arrays.stream(featureClassNames).collect(Collectors.toList());
    }

    public static List<Object[]> getData(HbaseConnection conn, String tableName, int pageIndex, int pageSize) throws Exception {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        SimpleFeatureType sft = AtlasGisToolkitApi.getSimpleFeatureType((String)"gw-vector", (String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        int total = AtlasGisToolkitApi.getCount((SimpleFeatureType)sft).intValue();
        int offset = pageIndex * pageSize;
        List<ColumnMeta> fields = HBaseTableMeta.getFields(conn, tableName);
        int fieldCount = fields.size();
        HbaseReader reader = AtlasHbaseDataApi.getHbaseReader((String)conn.getUrl(), (String)conn.getNamespace(), (String)tableName);
        ArrayList result = new ArrayList();
        Object[] element = null;
        reader.getSimpleFeatures(pageIndex, pageSize, result);
        for (int i = 0; i < result.size(); ++i) {
            SimpleFeature feat = (SimpleFeature)result.get(i);
            List objs = feat.getAttributes().stream().map(o -> {
                if (o instanceof Geometry) {
                    return ((Geometry)o).toString();
                }
                return o;
            }).collect(Collectors.toList());
            objs.add(0, offset + i);
            element = objs.toArray();
            datas.add(element);
        }
        return datas;
    }
}

