package com.northpool.resources.dialect.db.highgo;


import com.northpool.commons.util.StringUtility;
import com.northpool.resources.Constants;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ADialect;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.type.Type;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypeHighgoGeometry;
import com.northpool.type.Types;
import org.locationtech.jts.geom.Geometry;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;


@ADialect(name = "highgo",type = Constants.DATA_SOURCE_TYPE.highgo)
public class HighgoDialect extends AbstractSQLDialect implements ISQLDialect {

	public static HighgoDialect INSTANCE = new HighgoDialect();

	public static final String KEY_WORD_SERIAL = "serial";

	public static final String KEY_WORD_NOW_DATE = "current_timestamp";

	public static final String KEY_WORD_CURRENT_TIMESTAMP = "current_timestamp";

	public static final String KET_WORD_DEFAULT_SCHEMA = "public";

	public static final HighgoResourcesDataInput resourcesDataInput = new HighgoResourcesDataInput();

	public static final HighgoResourcesDataOutput resourcesDataOutput = new HighgoResourcesDataOutput();

	public HighgoDialect(){

		super();
		this.name = Constants.DATA_SOURCE_TYPE.highgo.name();
		
	}
	
	@Override
	public Constants.DATA_SOURCE_TYPE getDataSourceType() {
		return Constants.DATA_SOURCE_TYPE.highgo;
	}


	@Override
	protected void registerTypes(){
		this.registerType(Types.INTEGER, "serial","int", "int2", "int4", "integer");
		this.registerClassType(Types.INTEGER, Integer.class,Short.class);
		this.registerType(TypeHighgoGeometry.INSTANCE, "geometry");
		this.registerClassType(TypeHighgoGeometry.INSTANCE, Geometry.class, GeoBuffer.class);
		this.registerType(Types.STRING, "varchar","bpchar","character varying","text","json","jsonb","path");
		this.registerClassType(Types.STRING, String.class);
		this.registerType(Types.DOUBLE, "float","float4","float8","double");
		this.registerClassType(Types.DOUBLE, Double.class,Float.class);
		this.registerType(Types.BIGDECIMAL, "numeric","number");
		this.registerClassType(Types.BIGDECIMAL, BigDecimal.class,BigInteger.class);
		this.registerType(Types.TIME_STAMP, "timestamp","date");
		this.registerClassType(Types.TIME_STAMP, Date.class);
		this.registerType(Types.BOOLEAN, "boolean", "bool");
		this.registerClassType(Types.BOOLEAN, Boolean.class);	
		this.registerType(Types.LONG, "long","int8");
		this.registerClassType(Types.LONG, Long.class); 
		this.registerType(TypeBytes.INSTANCE, "bytea","byte[]");
        this.registerClassType(TypeBytes.INSTANCE, byte[].class);
	}
	
	//public com.northpool.resources.type.Type getInputType(java.lang.Object obj){if( obj instanceof java.lang.Long){ return com.northpool.resources.type.TypeLong.INSTANCE;};if( obj instanceof java.math.BigInteger){ return com.northpool.resources.type.TypeBigDecimal.INSTANCE;};if( obj instanceof java.util.Date){ return com.northpool.resources.type.TypeTimestamp.INSTANCE;};if( obj instanceof com.northpool.spatial.geofeature.GeoBuffer){ return com.northpool.resources.type.TypePGGeometry.INSTANCE;};if( obj instanceof java.math.BigDecimal){ return com.northpool.resources.type.TypeBigDecimal.INSTANCE;};if( obj instanceof java.lang.Short){ return com.northpool.resources.type.TypeInteger.INSTANCE;};if( obj instanceof java.lang.Double){ return com.northpool.resources.type.TypeDouble.INSTANCE;};if( obj instanceof java.lang.Float){ return com.northpool.resources.type.TypeDouble.INSTANCE;};if( obj instanceof java.lang.Boolean){ return com.northpool.resources.type.TypeBoolean.INSTANCE;};if( obj instanceof org.locationtech.jts.geom.Geometry){ return com.northpool.resources.type.TypePGGeometry.INSTANCE;};if( obj instanceof java.lang.String){ return com.northpool.resources.type.TypeString.INSTANCE;};if( obj instanceof [B){ return com.northpool.resources.type.TypeBytes.INSTANCE;};if( obj instanceof java.lang.Integer){ return com.northpool.resources.type.TypeInteger.INSTANCE;};return null;}

	@Override
	public String getSelfDesc() {
		// TODO Auto-generated method stub
		return "Highgo方言";
	}

	
	@Override
	protected void registerFunctions() {
		Type[] typeIn = new Type[]{TypeHighgoGeometry.INSTANCE, TypeHighgoGeometry.INSTANCE};
		//注册空间关系函数
		this.registerFunction("intersects", new SQLSpatialRelateFunction("st_intersects", Types.BOOLEAN,typeIn));
		this.registerFunction("equals", new SQLSpatialRelateFunction("st_equals", Types.BOOLEAN,typeIn));
		this.registerFunction("contains", new SQLSpatialRelateFunction("st_contains", Types.BOOLEAN,typeIn));
		this.registerFunction("crosses", new SQLSpatialRelateFunction("st_crosses", Types.BOOLEAN,typeIn));
		this.registerFunction("disjoint", new SQLSpatialRelateFunction("st_disjoint", Types.BOOLEAN,typeIn));
		this.registerFunction("touches", new SQLSpatialRelateFunction("st_touches", Types.BOOLEAN,typeIn));
		this.registerFunction("within", new SQLSpatialRelateFunction("st_within", Types.BOOLEAN,typeIn));
		this.registerFunction("overlaps", new SQLSpatialRelateFunction("st_overlaps", Types.BOOLEAN,typeIn));
		this.registerFunction("mbr_intersects", new SpatialFilterExpression(Types.BOOLEAN,typeIn));
	//	this.registerFunction("relate", new SpatialRelateFunction("st_relate", Types.BOOLEAN,typeIn));
	}

	
	
	


	@Override
	public String getJDBCDriver() {
		return "com.highgo.jdbc.Driver";
	}

	@Override
	public String createConnectUrl(String url) {
		return "jdbc:highgo://" + url;
	}

	@Override
	public Boolean markForTableNameAndColumnName() {
		// TODO Auto-generated method stub
		return true;
	}



	public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
		// TODO Auto-generated method stub
		connection.setAutoCommit(false);
		preparedStatement.setFetchSize(fetchSize);
		preparedStatement.setFetchDirection(ResultSet.FETCH_FORWARD);
	}

	/* (non-Javadoc)
	 * @see com.northpool.resources.dialect.db.SQLDialect#getDefaultSchema()
	 */
	@Override
	public String getDefaultSchema() {
		// TODO Auto-generated method stub
		return KET_WORD_DEFAULT_SCHEMA;
	}

	/* (non-Javadoc)
	 * @see com.northpool.resources.dialect.db.SQLDialect#isFieldSerial(java.lang.String)
	 */
	@Override
	public Boolean isFieldSerial(String columnTypeName) {
		// TODO Auto-generated method stub
		if(KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)){
			return true;
		}
		return false;
	}



	protected boolean defaultValueIsSequence(String columnTypeName,String defaultValue){
		/**
		 * 如果已经是自增字段，则不需要用序列
		 */
		if(isFieldSerial(columnTypeName)){
			return false;
		}
		if(defaultValue == null){
			return false;
		}
		if(defaultValue.startsWith("nextval(") && defaultValue.endsWith("::regclass)")){
			return true;
		}
		if(defaultValue.startsWith("nextval(".toUpperCase()) && defaultValue.endsWith("::regclass".toUpperCase())){
			return true;
		}
		return false;
	}

	protected boolean defaultValueIsFuntion(String columnTypeName,String defaultValue){
		/**
		 * 如果已经是自增字段，则不需要用序列
		 */
		if(isFieldSerial(columnTypeName)){
			return false;
		}
		return StringUtility.isFunction(defaultValue);
	}

	protected boolean defaultValueIsNowDate(String columnTypeName,String defaultValue){
		if(KEY_WORD_NOW_DATE.equalsIgnoreCase(defaultValue) || KEY_WORD_CURRENT_TIMESTAMP.equalsIgnoreCase(defaultValue)){
			return true;
		}
		return false;
	}


	public String createSequenceName(String schema, String tableName, String fieldName) {
		// TODO Auto-generated method stub
		StringBuilder seqName = new StringBuilder();
		if(schema == null || KET_WORD_DEFAULT_SCHEMA.equalsIgnoreCase(schema)){

		}else{
			seqName.append(schema.toLowerCase()).append("_");
		}
		seqName.append(tableName).append("_");
		seqName.append(fieldName).append("_seq");
		return seqName.toString();
	}


	@Override
	public String hasSequenceSql(String sequenceName) {
		String sql = "select relname from pg_class where relname = ?";
		return sql;
	}


	@Override
	public String getCreateSequenceSQL(String sequenceName) {
		// TODO Auto-generated method stub
		StringBuilder sql = new StringBuilder("CREATE SEQUENCE ") .append(sequenceName).append(" ")
				.append("INCREMENT 1 ")
				.append("MINVALUE 0 ")
				.append("MAXVALUE 9223372036854775807 ")
				.append("START 0 ")
				.append("CACHE 1 ");

		return sql.toString();
	}


	@SuppressWarnings("unchecked")
	@Override
	public ICreateTableFieldRefDialect<List<String>,String> getCreateTableFieldRefDialect() {
		return HighgoFieldRefDialect.INSTANCE;
	}


	@Override
	public boolean isColumnSerial(ColumnBean columnBean,String columnTypeName) {
		// TODO Auto-generated method stub
		if(KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)){
			return true;
		}
		return false;
	}

	public String processTableNameAndSchema(String tableName){
		return tableName;
	}


	@SuppressWarnings("unchecked")
	@Override
	public IResourcesDataInput<PreparedStatement,Integer> getResourcesDataDataInput() {
		return resourcesDataInput;
	}


	@SuppressWarnings("unchecked")
	@Override
	public IResourcesDataOutput<ResultSet,Integer> getResourcesDataOutput() {
		return resourcesDataOutput;
	}






}
