/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.dialect.db.highgo;

import com.northpool.resources.Constants;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.db.highgo.HighgoDialect;
import com.northpool.spatial.Constants;
import java.util.List;

public class HighgoFieldRefDialect
implements ICreateTableFieldRefDialect<List<String>, String> {
    public static final HighgoFieldRefDialect INSTANCE = new HighgoFieldRefDialect();

    void withNullable(StringBuilder part, ColumnBean bean) {
        if (!bean.getNullable().booleanValue()) {
            part.append(" NOT NULL ");
        }
    }

    void withRemarks(StringBuilder part, ColumnBean bean) {
        if (bean.getRemarks() != null) {
            // empty if block
        }
    }

    void withDefault(StringBuilder part, ColumnBean bean, String defaultKeyWord) {
        FieldDefaultValueBean fieldDefaultValue = bean.getFieldDefaultValue();
        if (fieldDefaultValue != null) {
            if (fieldDefaultValue.getType() == FieldDefaultValueBean.VALUE_TYPE.value) {
                part.append(" DEFAULT '").append(fieldDefaultValue).append("'").append(defaultKeyWord).append(" ");
            }
            if (fieldDefaultValue.getType() == FieldDefaultValueBean.VALUE_TYPE.function) {
                System.out.println("\u5b57\u6bb5\u9ed8\u8ba4\u503c\u4e0d\u652f\u6301\u51fd\u6570");
            }
            if (fieldDefaultValue.getType() == FieldDefaultValueBean.VALUE_TYPE.nowDate) {
                part.append(" DEFAULT now() ");
            }
            if (fieldDefaultValue.getType() == FieldDefaultValueBean.VALUE_TYPE.sequence) {
                // empty if block
            }
        }
    }

    public String columnBoolean(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" boolean ");
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::boolean");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnBigDecimal(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" numeric ");
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::numeric");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnBytes(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" bytea ");
        this.withNullable(part, bean);
        builder.add(part.toString());
        return part.toString();
    }

    public String columnDouble(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" float8 ");
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::float8");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnGeometry(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        Integer srid = bean.getSrid();
        Constants.GEO_TYPE geoType = bean.getGeoType();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" geometry (").append(geoType.name());
        if (bean.getDimension() == 3) {
            part.append("Z");
        }
        if (srid != null) {
            part.append(",").append(srid);
        }
        part.append(") ");
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::geometry");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnInteger(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" ");
        if (bean.getIsSerial().booleanValue()) {
            part.append("serial");
        } else {
            part.append("integer");
        }
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::integer");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnLong(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" ");
        if (bean.getIsSerial().booleanValue()) {
            part.append("serial");
        } else {
            part.append("bigint");
        }
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::bigint");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnString(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" character varying");
        if (bean.getColumnSize() != null) {
            part.append("(").append(bean.getColumnSize()).append(")");
        }
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::character varying");
        builder.add(part.toString());
        return part.toString();
    }

    public String columnTimestamp(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if (HighgoDialect.INSTANCE.markForTableNameAndColumnName().booleanValue()) {
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" timestamp without time zone");
        this.withNullable(part, bean);
        this.withDefault(part, bean, "::timestamp");
        builder.add(part.toString());
        return part.toString();
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.highgo;
    }
}

