package com.northpool.resources;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.WriteModel;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.List;

public interface MongodbDao {

	public void createIndex(String[] indexArray);

	public FindIterable<Document> findCollection(Bson filter);

	public FindIterable<Document> findCollection(Bson filter, Bson projection);

	public MongoCursor<Document> find(Bson filter);

	public MongoCursor<Document> find(Bson filter, Bson projection);

	public Document findone(Bson filter);

	public Document findone(Bson filter, Bson projection);

	public void insert(Document doc);

	public void insert(List<Document> docs);

	public void insertSaft(Document doc);

	public void update(Bson filter, Bson doc);

	public void batchUpdate(List<WriteModel<Document>> writeModelList);


	public void updateOne(Bson filter, Bson doc);


	public long count(Bson filter);
	
	public void deleteone(Bson filter);


}
