package com.northpool.resources;


import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;

public class MongodbFactory {
	
	protected MongoDatabase mongoDatabase = null;
	
	public MongodbFactory(MongoClient mongoClient, String databaseName){
		this.mongoDatabase = mongoClient.getDatabase(databaseName);
	}

	public MongodbDao getDao(String tableName){
		return new MongodbDaoImpl(this.mongoDatabase,tableName);
	}
	
	public MongoCollection getCollection(String tableName){
		return this.mongoDatabase.getCollection(tableName);
	}
	
	public Boolean collectionExist(String collectionName){
		MongoIterable<String> it = this.mongoDatabase.listCollectionNames();
		for (String name : it) {
			if (collectionName.equals(name)) {
				return true;
			}
		}
		return false;
	}
	
	public void createCollection(String collectionName, CreateCollectionOptions options){
		this.mongoDatabase.createCollection(collectionName, options);
	}


	public void dropCollection(String tableName) {
		MongoCollection collection = this.getCollection(tableName);
		if (collection != null){
			collection.drop();
		}
	}

	public void renameCollection(String tableName, String newName) {
		boolean isExists = this.collectionExist(newName);
		if (isExists){
			throw new RuntimeException(newName + "集合已经存在");
		}
		MongoCollection collection = this.getCollection(tableName);
		MongoNamespace namespace = new MongoNamespace(collection.getNamespace().getDatabaseName(), newName);
		collection.renameCollection(namespace);
	}
}
