package com.northpool.resources.datasource;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.Constants;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.MongodbDataSourceManager;
import com.northpool.resources.MongodbFactory;
import org.apache.commons.lang3.StringUtils;

import java.sql.ResultSet;

/**
 * MONGODB数据源
 * 
 * @author matt
 *
 */
@ADataSource(name = "db" ,types = "mongodb")
public class MongodbDataSource implements IDataSource {
	/**
	 * 主键
	 */
	protected String id;
	/**
	 * IP
	 */
	protected String ip;
	/**
	 * 端口
	 */
	protected Integer port;
	/**
	 * 用户名
	 */
	protected String user;
	/**
	 * 密码
	 */
	protected String password;
	/**
	 * 命名空间
	 */
	protected String namespace;


	/**
	 * 连接字符串，不为空时，优先使用，为空时，使用上述信息拼接为uri
	 */
	protected String uri;

	protected String version;

	/**
	 * 数据库类型
	 */
	protected Constants.DATA_SOURCE_TYPE dataSourceType = Constants.DATA_SOURCE_TYPE.mongodb;
	
	@Deprecated
	public MongodbDataSource(){
		
	}

	public MongodbDataSource(String uri){
		this.uri = uri;
	}
	
	public MongodbDataSource(String id,String ip,Integer port,String user,String password,String namespace){
		this.id = id;
		this.ip = ip;
		this.port = port;
		this.user = user;
		this.password = password;
		this.namespace = namespace;
	}
	
	public MongodbDataSource(String ip,Integer port,String user,String password,String namespace){
		
		this.ip = ip;
		this.port = port;
		this.user = user;
		this.password = password;
		this.namespace = namespace;
	
	}
	
	
	public MongodbDataSource(String id,String ip,Integer port,String namespace){
		this.ip = ip;
		this.port = port;
		this.namespace = namespace;
		this.id = id;
	}
	
	public MongodbDataSource(String ip,Integer port,String namespace){
		this.ip = ip;
		this.port = port;
		this.namespace = namespace;
		this.id = this.getMark();
	}
	
	

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}



	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	} 

	public String getNamespace() {
		return namespace;
	}

	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}
	
	
	public String toString() {
		if(this.user == null || "".equalsIgnoreCase("")){
			return new StringBuilder().append(this.getIp()).append('_').append(this.port).append('_').append(this.namespace).toString();
		}
		return new StringBuilder().append(this.getIp()).append('_').append(this.port).append('_').append(this.namespace).append('_').append(this.user).toString();
	}


	public String getConnectUrl(){
		return null;
	}


	public String toJson(){
		return JSON.toJSON(this).toString();
	}

	@Override
	public Constants.DATA_SOURCE_TYPE getDataSourceType() {
		return dataSourceType;
	}

	public MongodbDataSource createByJson(String json){
		return JSON.parseObject(json, MongodbDataSource.class);
	}

	@Override
	public <ConnectionPool> ConnectionPool connection() throws Exception {
		return null;
	}

	@Override
	public void resetConnection() {

	}

	@Override
	public void destory() {

	}

	@Override
	public ITableOperator getTableOperator(String tableName) throws Exception {
		return null;
	}

	@Override
	public void testConnection() {
		return;
	}

	@Override
	public ITable getTable(String tableName) throws Exception {
		return null;
	}

	@Override
	public ITable getTable(String tableName, FieldEncoder fieldEncoder) throws Exception {
		return null;
	}

	@Override
	public ITable getTable(String tableName, String[] selectFields) throws Exception {
		return null;
	}

	@Override
	public String[] tables() {
		return new String[0];
	}


	@Override
	public void drop(String tableName) {

	}

	@Override
	public void createTableBySchemaBean(TableSchemaBean schemaBean) {

	}

	@Override
	public ResultSet getSqlQuery(String sql) {
		return null;
	}

	@Override
	public Boolean executeSqlCommand(String sql) {
		return null;
	}


	@Override
	public Boolean hasSchema(String schema) {
		return null;
	}

	@Override
	public Boolean hasTable(String tableName) {
		return null;
	}

	public MongodbFactory factory(){
		return MongodbDataSourceManager.getInstance().getFactory(this.getUri());
	}


	public String getMark() {
		// TODO Auto-generated method stub
		return this.toString();
	}

	public Boolean isRelationalalDataBase() {
		// TODO Auto-generated method stub
		return false;
	}


	public void reId(String id) {
		// TODO Auto-generated method stub
		this.id = id;
	}

	public String getUri() {
		if (StringUtils.isEmpty(this.uri)){
			synchronized (this){
				this.uri = this.ip + ':' + this.port + '/' + this.namespace;
				if (StringUtils.isNotEmpty(this.user)){
					this.uri = this.user + ':' + this.password + '@' + this.uri;
				}
				this.uri = "mongodb://" + this.uri;
			}
		}
		//此处为防止切片和保存样式时，读写节点不一致造成的数据不一致，在管理系统中，一律使用主节点读写
		return uri.replace("readPreference=secondary", "readPreference=primary");
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	@Override
	public String mark() {
		return null;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}
}
