package com.northpool.resources;

import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.WriteModel;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.util.List;

public class MongodbDaoImpl implements MongodbDao {
	
	protected MongoCollection<Document> collection;
	
	public MongodbDaoImpl(MongoDatabase mongoDatabase,String collectionName) {
	
		collection = mongoDatabase.getCollection(collectionName);
		
	}


	@Override
	public void createIndex(String[] indexArray) {
		collection.createIndex(Indexes.ascending(indexArray));
	}

	@Override
	public FindIterable<Document> findCollection(Bson filter) {
		FindIterable<Document> it = collection.find(filter);
		return it;
	}

	@Override
	public FindIterable<Document> findCollection(Bson filter, Bson projection) {
		return this.findCollection(filter).projection(projection);
	}

	@Override
	public MongoCursor<Document> find(Bson filter) {
		FindIterable<Document> it = this.findCollection( filter);
		MongoCursor<Document> cursor = it.iterator();
		return cursor;
	}

	@Override
	public MongoCursor<Document> find(Bson filter, Bson projection) {
		FindIterable<Document> it = this.findCollection(filter).projection(projection);
		MongoCursor<Document> cursor = it.iterator();
		return cursor;
	}

	@Override
	public Document findone(Bson filter) {
		Document doc = null;
		try {
			FindIterable<Document> it = this.findCollection( filter);
			doc = it.first();
		}catch (Exception e){
			e.printStackTrace();
		}

		return doc;
	}

	@Override
	public Document findone(Bson filter, Bson projection) {
		FindIterable<Document> it = this.findCollection(filter).projection(projection);
		return it.first();
	}

	@Override
	public void insert(Document doc) {
		
		collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne(doc);
	}

	@Override
	public void insert(List<Document> list) {
		collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).insertMany(list);
	}

	@Override
	public void update(Bson filter, Bson doc) {
		collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateMany(filter, doc);
	}

	public void batchUpdate(List<WriteModel<Document>> writeModelList){
		collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).bulkWrite(writeModelList);
	}

	@Override
	public void updateOne( Bson filter, Bson doc) {
		collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne(filter, doc);
	}

	@Override
	public void insertSaft(Document doc) {
		collection.withWriteConcern(WriteConcern.JOURNALED).insertOne(doc);
	}

	@Override
	public long count(Bson filter) {
		return collection.countDocuments(filter);
	}
	
	
	@Override
	public void deleteone(Bson filter) {
		// TODO Auto-generated method stub
		collection.deleteOne(filter);
	}


	

	

}
