/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.Constants;
import com.northpool.resources.MongodbDataSourceManager;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.PasswordCrypo;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import java.sql.ResultSet;
import org.apache.commons.lang3.StringUtils;

@ADataSource(name="db", types="mongodb")
public class MongodbDataSource
implements IDataSource {
    protected String id;
    protected String ip;
    protected Integer port;
    protected String user;
    @Deprecated
    protected String password;
    protected String namespace;
    protected String crypoPassword;
    protected String uri;
    protected String version;
    protected Constants.DATA_SOURCE_TYPE dataSourceType = Constants.DATA_SOURCE_TYPE.mongodb;

    public MongodbDataSource() {
    }

    public MongodbDataSource(String uri) {
        this.uri = uri;
    }

    public MongodbDataSource(String id, String ip, Integer port, String user, String password, String namespace) {
        this.id = id;
        this.ip = ip;
        this.port = port;
        this.user = user;
        if (password != null) {
            this.crypoPassword = PasswordCrypo.encode((String)password);
        }
        this.namespace = namespace;
    }

    public MongodbDataSource(String ip, Integer port, String user, String password, String namespace) {
        this.ip = ip;
        this.port = port;
        this.user = user;
        if (password != null) {
            this.crypoPassword = PasswordCrypo.encode((String)password);
        }
        this.namespace = namespace;
    }

    public MongodbDataSource(String id, String ip, Integer port, String namespace) {
        this.ip = ip;
        this.port = port;
        this.namespace = namespace;
        this.id = id;
    }

    public MongodbDataSource(String ip, Integer port, String namespace) {
        this.ip = ip;
        this.port = port;
        this.namespace = namespace;
        this.id = this.getMark();
    }

    public String getId() {
        return this.id == null ? this.mark() : this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }

    @Deprecated
    public void setPassword(String password) {
        this.password = password;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String toString() {
        if (this.user == null || "".equalsIgnoreCase("")) {
            return this.getIp() + '_' + this.port + '_' + this.namespace;
        }
        return this.getIp() + '_' + this.port + '_' + this.namespace + '_' + this.user + '_' + this.crypoPassword;
    }

    public String getConnectUrl() {
        return null;
    }

    public String toJson() {
        return JSON.toJSON((Object)this).toString();
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return this.dataSourceType;
    }

    public MongodbDataSource createByJson(String json) {
        return (MongodbDataSource)JSON.parseObject((String)json, MongodbDataSource.class);
    }

    public <ConnectionPool> ConnectionPool connection() throws Exception {
        return null;
    }

    public void resetConnection() {
    }

    public void destory() {
    }

    public ITableOperator getTableOperator(String tableName) throws Exception {
        return null;
    }

    public void testConnection() {
    }

    public ITable getTable(String tableName) throws Exception {
        return null;
    }

    public ITable getTable(String tableName, FieldEncoder fieldEncoder) throws Exception {
        return null;
    }

    public ITable getTable(String tableName, String[] selectFields) throws Exception {
        return null;
    }

    public String[] tables() {
        return new String[0];
    }

    public void drop(String tableName) {
    }

    public String getCrypoPassword() {
        return this.crypoPassword;
    }

    public void setCrypoPassword(String crypoPassword) {
        this.crypoPassword = crypoPassword;
    }

    public void createTableBySchemaBean(TableSchemaBean schemaBean) {
    }

    public ResultSet getSqlQuery(String sql) {
        return null;
    }

    public Boolean executeSqlCommand(String sql) {
        return null;
    }

    public Boolean hasSchema(String schema) {
        return null;
    }

    public Boolean hasTable(String tableName) {
        return null;
    }

    public MongodbFactory factory() {
        return MongodbDataSourceManager.getInstance().getFactory(this.getUri());
    }

    protected String password() {
        if (this.password != null) {
            return this.password;
        }
        return PasswordCrypo.decode((String)this.crypoPassword);
    }

    public String getMark() {
        return this.toString();
    }

    public Boolean isRelationalalDataBase() {
        return false;
    }

    public void reId(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUri() {
        if (StringUtils.isEmpty((CharSequence)this.uri)) {
            MongodbDataSource mongodbDataSource = this;
            synchronized (mongodbDataSource) {
                this.uri = this.ip + ':' + this.port + '/' + this.namespace;
                if (StringUtils.isNotEmpty((CharSequence)this.user)) {
                    this.uri = this.user + ':' + this.password() + '@' + this.uri;
                }
                this.uri = "mongodb://" + this.uri;
            }
        }
        return this.uri.replace("readPreference=secondary", "readPreference=primary");
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String mark() {
        return this.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

