package com.northpool.resources;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.northpool.resources.utils.MongoClientURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class MongodbDataSourceManager {
	private Logger log = LoggerFactory.getLogger("MongodbDataSourceManager");

	private static MongodbDataSourceManager _manager = new MongodbDataSourceManager();
	
	private static Map<String, MongoClient> _cacheMap = new HashMap<String, MongoClient>();
	
	public static MongodbDataSourceManager getInstance() {
		return _manager;
	}
	
	private String getAliasName(String url,Integer port,String user,String databaseName) {

		String alias = url.replace("\\", "").replace("/", "").replace("_", "");
		StringBuffer beanName = new StringBuffer();
		beanName.append("mongodb").append("||");
		// 有别名时加上别名前缀
		beanName.append(alias).append("||");
		beanName.append(port).append("||");
		beanName.append(user).append("||");
		beanName.append(databaseName).append("||");
		beanName.append("mongoAddress");
		return beanName.toString();
	}


	public MongodbFactory getFactory(String uri){
		//MongoClients.create(uri);
/*		MongoClientSettings.Builder buide = MongoClientSettings.builder();
		buide.connectionsPerHost(20);// 与目标数据库可以建立的最大链接数
		buide.connectTimeout(1000 * 60 * 20);// 与数据库建立链接的超时时间
		buide.maxWaitTime(100 * 60 * 5 * 100);// 一个线程成功获取到一个可用数据库之前的最大等待时间
		buide.threadsAllowedToBlockForConnectionMultiplier(100);
		buide.maxConnectionIdleTime(0);
		buide.maxConnectionLifeTime(0);
		buide.socketTimeout(0);
		buide.socketKeepAlive(true);*/
		MongoClientURI mongoClientURI = new MongoClientURI(uri);
		String databaseName = mongoClientURI.getDatabase();
		MongoClient mongoClient = _cacheMap.get(uri);
		if(mongoClient == null){
			synchronized(this){
				mongoClient = _cacheMap.get(uri);
				if(mongoClient == null){
					try {
						//mongoClient = new MongoClient(mongoClientURI);
						mongoClient = MongoClients.create(uri);
					} catch (Exception e) {
						e.printStackTrace();
						throw new RuntimeException(e.getMessage());
					}
				}
			}
		}
		return new MongodbFactory(mongoClient,databaseName);
	}
	
	

	
	public synchronized void unRegisterMongoClient(String ip, int port,String userName,String databaseName){
		String mongodbAddressName = this.getAliasName(ip,port,userName,databaseName);
		MongoClient mongoClient = _cacheMap.get(mongodbAddressName);
		if(mongoClient != null){
			mongoClient.close();
			_cacheMap.remove(mongodbAddressName);
		}
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
/*	public synchronized MongodbDao regeditDao(String name, String ip, int post,String dbName,String userName,String password) {
		log.debug("初始化单mongodb实例连接");
		MongodbDao dao = new MongodbDaoImpl(ip, post,dbName,userName,password);
		_cacheMap.put(name, dao);
		return dao;
	}*/
	
	
}
