/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources;

import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.WriteModel;
import com.northpool.resources.MongodbDao;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongodbDaoImpl
implements MongodbDao {
    protected MongoCollection<Document> collection;

    public MongodbDaoImpl(MongoDatabase mongoDatabase, String collectionName) {
        this.collection = mongoDatabase.getCollection(collectionName);
    }

    @Override
    public void createIndex(String[] indexArray) {
        this.collection.createIndex(Indexes.ascending((String[])indexArray));
    }

    @Override
    public void createIndex(String[] indexArray, IndexOptions indexOptions) {
        this.collection.createIndex(Indexes.ascending((String[])indexArray), indexOptions);
    }

    @Override
    public void dropIndex(String[] indexArray) {
        this.collection.dropIndex(Indexes.ascending((String[])indexArray));
    }

    @Override
    public FindIterable<Document> findCollection(Bson filter) {
        FindIterable it = this.collection.find(filter);
        return it;
    }

    @Override
    public FindIterable<Document> findCollection(Bson filter, Bson projection) {
        return this.findCollection(filter).projection(projection);
    }

    @Override
    public MongoCursor<Document> find(Bson filter) {
        FindIterable<Document> it = this.findCollection(filter);
        MongoCursor cursor = it.iterator();
        return cursor;
    }

    @Override
    public MongoCursor<Document> find(Bson filter, Bson projection) {
        FindIterable it = this.findCollection(filter).projection(projection);
        MongoCursor cursor = it.iterator();
        return cursor;
    }

    @Override
    public Document findone(Bson filter) {
        Document doc = null;
        try {
            FindIterable<Document> it = this.findCollection(filter);
            doc = (Document)it.first();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    @Override
    public Document findone(Bson filter, Bson projection) {
        FindIterable it = this.findCollection(filter).projection(projection);
        return (Document)it.first();
    }

    @Override
    public void insert(Document doc) {
        this.collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).insertOne((Object)doc);
    }

    @Override
    public void insert(List<Document> list) {
        this.collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).insertMany(list);
    }

    @Override
    public void update(Bson filter, Bson doc) {
        this.collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).updateMany(filter, doc);
    }

    @Override
    public void batchUpdate(List<WriteModel<Document>> writeModelList) {
        this.collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).bulkWrite(writeModelList);
    }

    @Override
    public void updateOne(Bson filter, Bson doc) {
        this.collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED).updateOne(filter, doc);
    }

    @Override
    public void insertSaft(Document doc) {
        this.collection.withWriteConcern(WriteConcern.JOURNALED).insertOne((Object)doc);
    }

    @Override
    public long count(Bson filter) {
        return this.collection.countDocuments(filter);
    }

    @Override
    public void deleteone(Bson filter) {
        this.collection.deleteOne(filter);
    }

    @Override
    public void deleteMany(Bson filter) {
        this.collection.deleteMany(filter);
    }
}

