/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.utils.MongoClientURI;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbDataSourceManager {
    private Logger log = LoggerFactory.getLogger((String)"MongodbDataSourceManager");
    private static MongodbDataSourceManager _manager = new MongodbDataSourceManager();
    private static Map<String, MongoClient> _cacheMap = new HashMap<String, MongoClient>();

    public static MongodbDataSourceManager getInstance() {
        return _manager;
    }

    private String getAliasName(String url, Integer port, String user, String databaseName) {
        String alias = url.replace("\\", "").replace("/", "").replace("_", "");
        StringBuffer beanName = new StringBuffer();
        beanName.append("mongodb").append("||");
        beanName.append(alias).append("||");
        beanName.append(port).append("||");
        beanName.append(user).append("||");
        beanName.append(databaseName).append("||");
        beanName.append("mongoAddress");
        return beanName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongodbFactory getFactory(String uri) {
        MongoClientURI mongoClientURI = new MongoClientURI(uri);
        String databaseName = mongoClientURI.getDatabase();
        MongoClient mongoClient = _cacheMap.get(uri);
        if (mongoClient == null) {
            MongodbDataSourceManager mongodbDataSourceManager = this;
            synchronized (mongodbDataSourceManager) {
                mongoClient = _cacheMap.get(uri);
                if (mongoClient == null) {
                    try {
                        mongoClient = MongoClients.create((String)uri);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.getMessage());
                    }
                }
            }
        }
        return new MongodbFactory(mongoClient, databaseName);
    }

    public synchronized void unRegisterMongoClient(String ip, int port, String userName, String databaseName) {
        String mongodbAddressName = this.getAliasName(ip, port, userName, databaseName);
        MongoClient mongoClient = _cacheMap.get(mongodbAddressName);
        if (mongoClient != null) {
            mongoClient.close();
            _cacheMap.remove(mongodbAddressName);
        }
    }
}

