/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.ogr.shell.read;

import com.northpool.exception.UException;
import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import com.northpool.resources.datatable.ogr.operate.column.OgrColumn;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.thindriver.gdal.GDALInitializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;

public abstract class AbstractOgrReadShell
implements IOgrReadShell {
    protected DataSource ds;
    protected boolean loaded = false;
    protected Driver driver;
    protected String driverName;

    @Override
    public void close() {
        this.ds.FlushCache();
        this.ds.delete();
    }

    @Override
    public void reload() throws IOException {
        this.ds.FlushCache();
        this.ds.delete();
        this.load();
    }

    protected void tryInit() throws Exception {
        GDALInitializer.initLibraries();
        this.driver = ogr.GetDriverByName((String)this.driverName);
    }

    @Override
    public abstract void load() throws IOException;

    @Override
    public String[] getTables() {
        int layerCount = this.ds.GetLayerCount();
        String[] tables = new String[layerCount];
        for (int i = 0; i < layerCount; ++i) {
            tables[i] = this.ds.GetLayer(i).GetName();
        }
        return tables;
    }

    @Override
    public boolean hasTable(String tableName) {
        return this.getTable(tableName) != null;
    }

    @Override
    public DataSource getDataSource() {
        return this.ds;
    }

    private Layer getTable(String tableName) {
        int layerCount = this.ds.GetLayerCount();
        for (int i = 0; i < layerCount; ++i) {
            if (!this.ds.GetLayer(i).GetName().equalsIgnoreCase(tableName)) continue;
            return this.ds.GetLayer(i);
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, IColumn> getColumnMap(String tableName) throws TableNotFoundException {
        LinkedHashMap<String, IColumn> map = new LinkedHashMap<String, IColumn>();
        Layer layer = this.getTable(tableName);
        if (layer == null) {
            throw new TableNotFoundException(tableName);
        }
        int fieldsCount = layer.GetLayerDefn().GetFieldCount();
        for (int i = 0; i < fieldsCount; ++i) {
            FieldDefn fieldDefn = layer.GetLayerDefn().GetFieldDefn(i);
            String columnName = fieldDefn.GetName();
            int columnSize = fieldDefn.GetWidth();
            boolean nullable = false;
            if (fieldDefn.IsNullable() == 1) {
                nullable = true;
            }
            String columnTypeName = fieldDefn.GetTypeName();
            String remarks = fieldDefn.GetAlternativeName();
            OgrColumn column = new OgrColumn(columnName, columnSize, columnTypeName, nullable, remarks);
            map.put(columnName, column);
        }
        String idColumnName = layer.GetFIDColumn();
        if (StringUtils.isEmpty((CharSequence)idColumnName)) {
            idColumnName = "FID";
        }
        OgrColumn idFGDBColumn = OgrColumn.createIdColumn(idColumnName);
        map.put(idColumnName, idFGDBColumn);
        String spatialColumnName = layer.GetGeometryColumn();
        if (StringUtils.isEmpty((CharSequence)spatialColumnName)) {
            spatialColumnName = "_ogr_geometry_";
        }
        Integer SRID = this.getSRID(tableName);
        OgrColumn spatialFGDBColumn = OgrColumn.createSpatialColumn(spatialColumnName, SRID, layer.GetGeomType());
        map.put(spatialColumnName, spatialFGDBColumn);
        return map;
    }

    private Integer getSRID(String tableName) {
        Integer srid = null;
        Layer layer = this.getTable(tableName);
        SpatialReference spatialReference = layer.GetSpatialRef();
        try {
            srid = Integer.valueOf(spatialReference.GetAttrValue("AUTHORITY", 1));
            return srid;
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            return null;
        }
    }

    @Override
    public String geTableRemarks(String tableName) throws TableNotFoundException {
        Layer layer = this.getTable(tableName);
        if (layer == null) {
            throw new TableNotFoundException(tableName);
        }
        return layer.GetDescription();
    }
}

