/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.ogr;

import com.northpool.exception.UException;
import com.northpool.resources.Constants;
import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.ogr.IOgrTransformer;
import com.northpool.resources.datatable.ogr.OgrQuery;
import com.northpool.resources.datatable.ogr.OgrTable;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.sql.IQuery;
import com.northpool.resources.sql.SQLParameter;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.type.Type;
import java.util.List;
import java.util.Map;

public class AbstractOgrDAO<PK, T>
implements IDAO<T, PK> {
    protected IDataSource dataSource;
    protected OgrDialect dialect;
    protected OgrTable ogrTable;
    protected Class<?> clazz;
    protected IOgrTransformer<T> transformer;

    public AbstractOgrDAO(IDataSource dataSource, OgrTable ogrTable, IOgrTransformer<T> transformer) {
        this.dataSource = dataSource;
        this.dialect = (OgrDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)dataSource.getDataSourceType());
        this.ogrTable = ogrTable;
        this.transformer = transformer;
    }

    public T get(PK pk) throws DataAccessException {
        return null;
    }

    public Long count(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public List<T> query(QueryFilter queryFilter) throws DataAccessException {
        return null;
    }

    public List<T> query(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine((ITable)this.ogrTable, queryFilter).exceptSpatialFilter();
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IQuery<T, IOgrTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), this.transformer, parameter.getSpatialCommand());
        return query.list();
    }

    public List<Object[]> queryArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine((ITable)this.ogrTable, queryFilter).exceptSpatialFilter();
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IQuery<Object[], IOgrTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), IOgrTransformer.ARRAY, parameter.getSpatialCommand());
        return query.list();
    }

    private <ST> IScroll<ST> _scroll(QueryFilter queryFilter, Integer fetchSize, IOgrTransformer<ST> transformer) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine((ITable)this.ogrTable, queryFilter).exceptSpatialFilter().doNotUseAliasName();
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IQuery<ST, IOgrTransformer<?>> query = this.createQuery(parameter.getSql(), parameter.getReturnFieldArray(), parameter.getValues(), parameter.getTypes(), queryFilter.getStart(), queryFilter.getEnd(), parameter.getReturnTypeMap(), transformer, parameter.getSpatialCommand());
        return query.scroll();
    }

    public IScroll<T> scroll(QueryFilter queryFilter) throws DataAccessException {
        return this.scroll(queryFilter, null);
    }

    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IOgrTransformer.ARRAY);
    }

    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        return null;
    }

    public PK saveOrUpdate(T t) throws DataAccessException {
        return null;
    }

    public void remove(PK pk) throws DataAccessException {
    }

    public List<PK> update(T t) throws DataAccessException {
        return null;
    }

    public List<PK> update(T t, String[] includeFields) throws DataAccessException {
        return null;
    }

    public void removeAll() throws DataAccessException {
    }

    public List<PK> insertMany(List<T> list) throws DataAccessException {
        return this.insertMany(list, IDAO.DEFALT_BATCH_SIZE);
    }

    public List<PK> insertMany(List<T> list, Integer batchSize) throws DataAccessException {
        return null;
    }

    public List<PK> insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        return null;
    }

    public void updateMany(T o, QueryFilter queryFilter) throws DataAccessException {
    }

    public void remove(QueryFilter queryFilter) throws DataAccessException {
    }

    public PK insert(T t) throws DataAccessException {
        return null;
    }

    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            Type t;
            Object arg = args[i];
            types[i] = t = this.dialect.getTypeByObject(arg);
        }
        return types;
    }

    protected <ST> IQuery<ST, IOgrTransformer<?>> createQuery(String sql, String[] selectFieldArray, Object[] args, Type[] types, Integer firstResult, Integer maxResults, Map<String, Type> returnType, IOgrTransformer<ST> transformer, SpatialCommand command) throws DataAccessException {
        OgrQuery query = new OgrQuery(this.dataSource, this.dialect, sql, selectFieldArray, this.ogrTable, command);
        query.setResultTransformer(transformer);
        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes = types == null ? this.guessType(args) : types;
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }
        query.setFirstResult(firstResult).setMaxResults(maxResults);
        return query;
    }

    public IScroll scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IOgrTransformer.MAP);
    }
}

