/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.ogr.operate;

import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.ogr.OgrTable;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.spatial.geofeature.GeoBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OgrTableOperator
extends AbstractTableOperator
implements ITableOperator {
    Logger logger = LoggerFactory.getLogger(OgrTableOperator.class);
    protected IOgrShellDataSource ogrShellDataSource;
    protected IOgrReadShell readShell;

    public String mark() {
        return this.tableName + "@" + this.dataSource.mark();
    }

    protected CompletableFuture<Object> getEmptyPromise() {
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> null);
        return promise;
    }

    public CompletableFuture<Object> createPK(String colname) {
        this.logger.info(this.dataSource.getDataSourceType().name() + " \u4e0d\u652f\u6301\u521b\u5efa\u4e3b\u952e");
        return this.getEmptyPromise();
    }

    public CompletableFuture<Object> _createIndex(Boolean unique, String ... colnames) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "\u53ea\u8bfb\u6a21\u5f0f\u4e0d\u652f\u6301\u521b\u5efa\u7d22\u5f15");
    }

    public CompletableFuture<Object> dropIndex(String indexName) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "\u53ea\u8bfb\u6a21\u5f0f\u4e0d\u652f\u6301\u5220\u9664\u7d22\u5f15");
    }

    public CompletableFuture<Object> dropPK() {
        this.logger.info(this.dataSource.getDataSourceType().name() + " \u4e0d\u652f\u6301\u5220\u9664\u4e3b\u952e");
        return this.getEmptyPromise();
    }

    protected Object[] getSpatialInfo(String colunmName) throws Exception {
        return null;
    }

    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws Exception {
        return null;
    }

    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        this.tableName = tableName;
        this.dataSource = dataSource;
        this.ogrShellDataSource = (IOgrShellDataSource)dataSource;
        IOgrConnection connection = (IOgrConnection)this.ogrShellDataSource.connection();
        this.readShell = connection.getReadShell();
        this.dialect = OgrDialect.INSTANCE;
        this.buildTableInfo(this.tableName);
    }

    protected void buildTableInfo(String tableName) throws TableNotFoundException {
        this.getTableInfo(tableName);
        this.buildColumns(tableName);
        this.buildIndexInfo(tableName);
    }

    protected void getTableInfo(String tableName) throws TableNotFoundException {
        this.isView = false;
        this.tableRemarks = this.readShell.geTableRemarks(tableName);
    }

    protected void buildColumns(String tableName) throws TableNotFoundException {
        this.columnMap = this.readShell.getColumnMap(tableName);
    }

    protected List<Index> getIndexInfo(String tableName) {
        String geometryColumn;
        ArrayList<Index> list = new ArrayList<Index>(2);
        DataSource dataSource = this.readShell.getDataSource();
        Layer layer = dataSource.GetLayer(tableName);
        String fidColumn = layer.GetFIDColumn();
        if (StringUtils.isEmpty((CharSequence)fidColumn)) {
            fidColumn = "FID";
        }
        if (StringUtils.isEmpty((CharSequence)(geometryColumn = layer.GetGeometryColumn()))) {
            geometryColumn = "_ogr_geometry_";
        }
        Index index = new Index();
        index.setAsc("asc");
        index.setName(fidColumn + "_idx");
        index.setUnique(Boolean.valueOf(true));
        index.setIsPK(Boolean.valueOf(true));
        index.addColname(fidColumn);
        list.add(index);
        index = new Index();
        index.setAsc("asc");
        index.setName(geometryColumn + "_spx");
        index.setUnique(Boolean.valueOf(false));
        index.addColname(geometryColumn);
        index.isSpatial(Boolean.valueOf(true));
        list.add(index);
        return list;
    }

    protected void buildIndexInfo(String tableName) throws TableNotFoundException {
        List<Index> indexList = this.getIndexInfo(tableName);
        for (Index index : indexList) {
            this.indexMap.put(index.getName(), index);
        }
    }

    protected AbstractTable _getTable() {
        return new OgrTable();
    }

    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "\u53ea\u8bfb\u6a21\u5f0f\u4e0d\u652f\u6301\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15");
    }
}

