/**
　 * <p>Title: FGDBOperator.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datatable.ogr.operate;


import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.ogr.OgrTable;
import com.northpool.resources.datatable.operate.AbstractTableOperator;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.spatial.geofeature.GeoBuffer;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * @author matt
 *
 */
public abstract class OgrTableOperator extends AbstractTableOperator implements ITableOperator {

    Logger logger = LoggerFactory.getLogger(OgrTableOperator.class);

    protected IOgrShellDataSource ogrShellDataSource;
    
    protected IOgrReadShell readShell;
    
    @Override
    public String mark() {
        // TODO Auto-generated method stub
        return new StringBuilder().append(this.tableName).append("@").append(this.dataSource.mark()).toString();
    }

    protected CompletableFuture<Object> getEmptyPromise(){
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() ->{
            return null;
        });
        return promise; 
    }
    
   
    @Override
    public CompletableFuture<Object> createPK(String colname) {
        // TODO Auto-generated method stub
        logger.info(this.dataSource.getDataSourceType().name() + " 不支持创建主键");

        return getEmptyPromise();
    }

   
    
    
    @Override
    public CompletableFuture<Object> _createIndex(Boolean unique, String... colnames) {
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "只读模式不支持创建索引");

    }

   
    @Override
    public CompletableFuture<Object> dropIndex(String indexName) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "只读模式不支持删除索引");

    }

   
    @Override
    public CompletableFuture<Object> dropPK() {
        // TODO Auto-generated method stub
        logger.info(this.dataSource.getDataSourceType().name() + " 不支持删除主键");
        return getEmptyPromise();
    }

    
    @Override
    protected Object[] getSpatialInfo(String colunmName) throws Exception {
        // TODO Auto-generated method stub
        //无需实现
        return null;

    }

    
    @Override
    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws Exception {
       // TODO Auto-generated method stub
      //无需实现
        return null; 
    }

    @Override
    public void init(String tableName, IDataSource dataSource, Map<String, ?> config) throws Exception {
        // TODO Auto-generated method stub
        this.tableName = tableName;
        this.dataSource = dataSource;
        this.ogrShellDataSource = (IOgrShellDataSource) dataSource;
        IOgrConnection connection = ogrShellDataSource.connection();
        this.readShell = connection.getReadShell();
        
        this.dialect = OgrDialect.INSTANCE;

        this.buildTableInfo(this.tableName);
        /*if(this.hasSpatialColumn()){
            this.buildSpatialColumnInfo();
        }*/
        
        
    }

/*    public IColumn getPKColumnInfo(){
        return new OgrColumn("OBJECTID", 255, "INTEGER", false, null );
    }

    @Override
    public String getPKColumn(){
        return "OBJECTID";
    }*/
    
    protected void buildTableInfo(String tableName) throws TableNotFoundException {
        // TODO Auto-generated method stub
        this.getTableInfo(tableName);
        this.buildColumns(tableName);
        this.buildIndexInfo(tableName);
    }
    
    
    protected void getTableInfo(String tableName) throws TableNotFoundException{
        this.isView = false;
        this.tableRemarks = this.readShell.geTableRemarks(tableName);
    }

    protected void buildColumns(String tableName) throws TableNotFoundException{
        this.columnMap = this.readShell.getColumnMap(tableName);
    }
    
    protected List<Index> getIndexInfo(String tableName){
        List<Index> list = new ArrayList<>(2);

        DataSource dataSource = this.readShell.getDataSource();
        Layer layer = dataSource.GetLayer(tableName);
        String fidColumn = layer.GetFIDColumn();
        if (StringUtils.isEmpty(fidColumn)) {
            fidColumn = "FID";
        }

        String geometryColumn = layer.GetGeometryColumn();
        if (StringUtils.isEmpty(geometryColumn)) {
            geometryColumn = "_ogr_geometry_";
        }

        Index index = new Index();
        index.setAsc("asc");
        index.setName(fidColumn + "_idx");
        index.setUnique(true);
        index.setIsPK(true);
        index.addColname(fidColumn);
        list.add(index);


        index = new Index();
        index.setAsc("asc");
        index.setName(geometryColumn + "_spx");
        index.setUnique(false);
        index.addColname(geometryColumn);
        index.isSpatial(true);
        list.add(index);
        /*FGDBDataSource gdbDataSource = (FGDBDataSource)dataSource;
        Cmd cmd = new Cmd(Cmd.CMD_TYPE.getIndex,tableName);
        gdbDataSource.connection().getESRIShell().addCmd(cmd);

        gdbDataSource.connection().getGDALShell().getDataSource().
        try {
            List<IndexXMLBean> indexBeanList = (List<IndexXMLBean>)cmd.getPromise().get();
            List<Index> indexList = new ArrayList<>(indexBeanList.size());
            for(IndexXMLBean indexBean : indexBeanList){
                Index index = new Index();
                index.setName(indexBean.getName());
                index.setUnique(indexBean.getIsUnique());
                if(indexBean.getFields().size() == 1){
                    if(FGDBDialect.KEY_WORD_SERIAL.equalsIgnoreCase(indexBean.getFields().get(0).getType())){
                        index.setIsPK(true);
                    }
                    if(FGDBDialect.KEY__WORD_GEOMETRY.equalsIgnoreCase(indexBean.getFields().get(0).getType())){
                        index.setSpatial(true);
                    }
                }
                for(FieldXmlBean field : indexBean.getFields()){
                    index.addColname(field.getName());
                }
                indexList.add(index);
            }
            
            return indexList;
            
        } catch (InterruptedException | ExecutionException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new RuntimeException(e);
        }*/
        return list;
    }
    
    
    protected void buildIndexInfo(String tableName) throws TableNotFoundException{
        List<Index> indexList = this.getIndexInfo(tableName);
        for(Index index : indexList){
            this.indexMap.put(index.getName(), index);
        }
    }
    

 
    @SuppressWarnings("unchecked")
    @Override
    protected AbstractTable _getTable() {
        // TODO Auto-generated method stub
        return new OgrTable();
    }


    @Override
    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        // TODO Auto-generated method stub

        throw new UnsupportedOperationException(this.dataSource.getDataSourceType().name() + "只读模式不支持创建空间索引");

    }

   

   

   

}
