/**
　 * <p>Title: FGDBPool.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr.shell.read;

import java.io.IOException;

/**
 * @author matt
 *
 */
public class FileOgrReadShell extends AbstractOgrReadShell {
    protected String file;

    public void close(){
        this.ds.FlushCache();
        this.ds.delete();
    }

    public FileOgrReadShell(String file) {
        super();
        this.file = file;

    }
    

    public synchronized void load() throws IOException{
        this.loaded = false;
        this.ds = this.driver.Open(this.file);
        if(this.ds == null){
            throw new IOException("文件 " + file + "不存在或不是合法的fgdb文件格式");
        }
        this.loaded = true;
    }
   

    
}
