/**
　 * <p>Title: WkbEncoder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年7月13日
　 * @version 1.0
*/
package com.northpool.spatial;

import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.AbstractWkbEncoder;
import org.gdal.ogr.Geometry;

import java.nio.ByteOrder;

/**
 * @author matt
 *
 */
@AGeomEncoder(type = SPATIAL_TYPE.gdalGeometry)
public class OgrGeometryEncoder extends AbstractWkbEncoder implements GeomEncoder<Geometry>  {
     
    @Override
    public Geometry fromGeoBuffer(GeoBuffer geoBuffer) {
        // TODO Auto-generated method stub
        String wkt = geoBuffer.toWkt();
        return Geometry.CreateFromWkt(wkt);
    }

   
    @Override
    public Geometry fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {
        // TODO Auto-generated method stub
        return this.fromGeoBuffer(geoBuffer);
    }
}
