/**
　 * <p>Title: FGDBDataSource.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr;


import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.connection.ShapeOgrConnection;
import com.northpool.resources.datasource.ogr.pool.OgrShellPool;
import com.northpool.resources.datasource.ogr.pool.ShapeShellPool;

import java.io.IOException;


@ADataSource(name = "shape" ,types = "shape")
public class ShapeDataSource extends FileOgrDataSource implements IDataSource {


    public ShapeDataSource(String filePath){
        super(filePath);
        this.dataSourceType = DATA_SOURCE_TYPE.shape;
    }


    public ShapeDataSource(String id, String filePath){
        super(id,filePath);
        this.dataSourceType = DATA_SOURCE_TYPE.shape;
    }

    @Override
    public IOgrConnection connection() throws IOException {
        return new ShapeOgrConnection(this, this.filePath);
    }

    @Override
    public OgrShellPool createOgrShellPool() {
        return new ShapeShellPool(this.filePath);
    }
}
