/**
　 * <p>Title: FGDBShell.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr.connection;


import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.pool.OgrShellPool;
import com.northpool.resources.datasource.ogr.pool.OgrShellPoolManager;
import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import com.northpool.resources.datasource.ogr.shell.write.IOgrWriteShell;

import java.io.IOException;

/**
 * @author matt
 *
 */
public abstract class AbstractOgrConnection implements IOgrConnection {

    IOgrReadShell readShell;

    IOgrWriteShell writeShell;

    IOgrShellDataSource dataSource;

    public AbstractOgrConnection(IOgrShellDataSource dataSource) throws IOException {
        this.dataSource = dataSource;
        OgrShellPool ogrShellPool = OgrShellPoolManager.getInstance().getOgrShellPool(dataSource);
        this.readShell = ogrShellPool.getReadShell();
    }

    @Override
    public IOgrReadShell getReadShell() {
        return readShell;
    }

    public void setReadShell(IOgrReadShell readShell) {
        this.readShell = readShell;
    }

    @Override
    public IOgrWriteShell getWriteShell() {
        return writeShell;
    }

    public void setWriteShell(IOgrWriteShell writeShell) {
        this.writeShell = writeShell;
    }

}
