/**
　 * <p>Title: FGDBPool.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年7月20日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr.shell.read;

import com.northpool.exception.UException;
import com.northpool.resources.datatable.ogr.operate.column.OgrColumn;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.exception.TableNotFoundException;
import com.northpool.thindriver.gdal.GDALInitializer;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.*;
import org.gdal.osr.SpatialReference;

import java.io.IOException;
import java.util.LinkedHashMap;

/**
 * @author matt
 *
 */
public abstract class AbstractOgrReadShell implements IOgrReadShell {
    protected DataSource ds;
    protected boolean loaded = false;
    protected Driver driver;
    protected String driverName;

    public void close(){
        this.ds.FlushCache();
        this.ds.delete();
    }

    public AbstractOgrReadShell() {
    }

    public void reload() throws IOException{
        this.ds.FlushCache();
        this.ds.delete();
        this.load();
    }


    protected void tryInit() throws Exception{
        GDALInitializer.initLibraries();
        this.driver = ogr.GetDriverByName(this.driverName);

    }

    public abstract void load() throws IOException;

    public String[] getTables(){
       int layerCount = this.ds.GetLayerCount();
       String[] tables = new String[layerCount];
       for(int i = 0 ; i < layerCount ; i ++){
           tables[i] = this.ds.GetLayer(i).GetName();
       }
       return tables;
    }

    public boolean hasTable(String tableName){
        if(this.getTable(tableName) != null){
            return true;
        }
        return false;
    }

    public DataSource getDataSource(){
        return this.ds;
    }

    private Layer getTable(String tableName){
        int layerCount = this.ds.GetLayerCount();
        for(int i = 0 ; i < layerCount ; i ++){
            if(this.ds.GetLayer(i).GetName().equalsIgnoreCase(tableName)){
                return this.ds.GetLayer(i);
            }
        }
        return null;
    }

    public LinkedHashMap<String,IColumn> getColumnMap(String tableName) throws TableNotFoundException{
        LinkedHashMap<String,IColumn> map = new LinkedHashMap<>();
        Layer layer = this.getTable(tableName);
        if(layer == null){
            throw new TableNotFoundException(tableName);
        }
        layer.ResetReading();
        int fieldsCount = layer.GetLayerDefn().GetFieldCount();
        for(int i = 0 ; i < fieldsCount; i ++){
            FieldDefn fieldDefn = layer.GetLayerDefn().GetFieldDefn(i);
            String columnName = fieldDefn.GetName();
            int columnSize = fieldDefn.GetWidth();
            boolean nullable = false;
            if(fieldDefn.IsNullable() == 1){
                nullable = true;
            }
            /*boolean unique = false;
            if(fieldDefn.IsUnique() == 1){
                unique = true;
            }*/
            //fieldDefn.

            String columnTypeName = fieldDefn.GetTypeName();

            String remarks = fieldDefn.GetAlternativeName();
            OgrColumn column = new OgrColumn(columnName,columnSize,columnTypeName,nullable,remarks);

            map.put(columnName, column);

        }
        //提取ID
        String idColumnName = layer.GetFIDColumn();
        if (StringUtils.isEmpty(idColumnName)) {
            idColumnName = "FID";
        }
        OgrColumn idFGDBColumn = OgrColumn.createIdColumn(idColumnName);
        map.put(idColumnName, idFGDBColumn);


        String spatialColumnName = layer.GetGeometryColumn();
        if (StringUtils.isEmpty(spatialColumnName)) {
            spatialColumnName = "_ogr_geometry_";
        }
        ;

  //      SpatialReference spatialReference = layer.GetSpatialRef();

        Integer SRID = this.getSRID(tableName);

        OgrColumn spatialFGDBColumn = OgrColumn.createSpatialColumn(spatialColumnName, SRID,layer.GetGeomType());

        map.put(spatialColumnName, spatialFGDBColumn);

        return map;

    }

    private Integer getSRID(String tableName){
        Integer srid = null;
        Layer layer = this.getTable(tableName);
        SpatialReference spatialReference = layer.GetSpatialRef();
        try{
            srid = Integer.valueOf(spatialReference.GetAttrValue("AUTHORITY", 1));
            return srid;
        }catch(Exception e){
            UException.printStackTrace(e);
            return null;
        }

    }




    public String geTableRemarks(String tableName) throws TableNotFoundException{
        Layer layer = this.getTable(tableName);
        if(layer == null){
            throw new TableNotFoundException(tableName);
        }
        return layer.GetDescription();
    }



    //public



}
