/**
　 * <p>Title: FGDBQuery.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月29日
　 * @version 1.0 
*/
package com.northpool.resources.datatable.ogr;


import com.northpool.resources.command.CommandImpl.SpatialCommand;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.resources.dialect.ogr.OgrQueryParmsDataInput;
import com.northpool.resources.sql.IQuery;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.Geom;
import com.northpool.type.Type;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


/**
 * @author matt
 *
 */
public class OgrQuery<T> implements IQuery<T, IOgrTransformer<T>> {

    OgrDialect dialect;
    IOgrTransformer<T> transformer;
    String sql;
    Map<String,Type> returnTypeMap = new HashMap<String,Type>();
    
    int firstResult = -1;
    int maxResults = -1;
    Integer fetchSize; 
    
    List<Type> inputTypes = new ArrayList<>();
    
    IOgrShellDataSource ogrShellDataSource;
    
    boolean ignoreWarnings = false;
    
    static final Logger logger = LoggerFactory.getLogger(OgrQuery.class);
    
    List<Object> parameterList = new ArrayList<Object>();
    
    SpatialCommand command;
    
    ITable table;
    
    String[] queryFields;
    
    
    /**
     * @param dataSource
     */
    public OgrQuery(IDataSource dataSource, OgrDialect dialect, String sql, String[] queryFields, ITable table , SpatialCommand command) {
        // TODO Auto-generated constructor stub
        this.ogrShellDataSource = (IOgrShellDataSource) dataSource;
        this.dialect = dialect;
        this.sql = sql;
        this.command = command;
        this.table = table;
        this.queryFields = queryFields;
        
    }


    @Override
    public IQuery<T, IOgrTransformer<T>> setResultTransformer(IOgrTransformer<T> transformer) {
        this.transformer = transformer;
        return this;
    }

    
    @Override
    public IQuery<T, IOgrTransformer<T>> addScalar(String key, Type type) {
        this.returnTypeMap.put(key, type);
        return this;
    }

   
    @Override
    public IQuery<T, IOgrTransformer<T>> addScalar(Map<String, Type> returnTypeMap) {
        this.returnTypeMap = returnTypeMap;
        return this;
    }

   
    @Override
    public IQuery<T, IOgrTransformer<T>> setParameter(int index, Object arg) {
        this.parameterList.add(index, arg);
        return this;
    }

    @Override
    public IQuery<T, IOgrTransformer<T>> setFirstResult(Integer firstResult) {
        if(firstResult != null){
            this.firstResult = firstResult;
        }
        return this;
    }

    
    @Override
    public IQuery<T, IOgrTransformer<T>> setMaxResults(Integer maxResults) {
        if(maxResults != null){
            this.maxResults = maxResults;
        }
        return this;
    }

    
    @Override
    public IQuery<T, IOgrTransformer<T>> setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    
    @Override
    public IQuery<T, IOgrTransformer<T>> setParameters(Object[] args) {
        this.parameterList.addAll(Arrays.asList(args));
        return this;
    }

   
    @Override
    public void setInputTypes(Type[] inputTypes) {
        if(inputTypes != null){
            this.inputTypes = new ArrayList<Type>(Arrays.asList(inputTypes));
        }
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.sql.IQuery#list()
     */
    @Override
    public List<T> list() throws DataAccessException {
        long start = System.currentTimeMillis();
       IScroll<T> scroll = this.scroll();
       List<T> list = new ArrayList<>();
       //int count = 0;
       while (scroll.hasNext()){
           T next = scroll.next();
           if (next != null){
               list.add(next);
           }
           //count++;
       }

/*       if (count != 0 && maxResults == 1 && list.isEmpty()){
           ArrayList<T> objects = new ArrayList<>(1);
           objects.add(null);
           return objects;
       }*/
       //System.out.println("list time: " + (System.currentTimeMillis() - start));
       return list;
    }


    protected void printSQL(){
        logger.debug(this.sql);
        logger.debug("use parameters:" + StringUtils.join(this.parameterList, ","));
    }
    
    /**
     * 将参数注入到SQL中
     * @param sql
     * @param args
     * @param types
     * @return
     */
    private String setValuesIntoSql(String sql,Object[] args,Type[] types){
        int size = args.length;
        if(args.length != types.length){
            throw new RuntimeException("查询时值的长度需要和类型的长度一致");
        }
        
        List<String> parmsList = new ArrayList<>();
        for(int i = 0 ; i < size ; i ++){
            OgrQueryParmsDataInput.INSTANCE.input(parmsList, types[i], args[i] , i);
            sql = StringUtils.replaceOnce(sql, "?", parmsList.get(i));
        }
        return sql;
    }
    
    private Layer executeSQL(DataSource dataSource,String sql,SpatialCommand command){
        Layer layer = null;
        if(command == null){
            //sql = sql.substring(0 ,sql.indexOf("from") - 25) + " " + sql.substring(sql.lastIndexOf("from"));
            layer = dataSource.ExecuteSQL(sql);
        }else{
            command.build(dialect);
            Geom geom = command.getGeometry();
            geom.changeType(SPATIAL_TYPE.gdalGeometry);
            // TODO: 2022/3/21 这里先临时处理一下，后面需要修改where null的bug
            sql = sql.replace("where null", "");
            layer = dataSource.ExecuteSQL(sql,(org.gdal.ogr.Geometry)geom.getOriginGeom());
/*            System.out.println("finnal sql is : " + sql);
            System.out.println("region:" + ((org.gdal.ogr.Geometry)geom.getOriginGeom()).ExportToWkt());
            System.out.println("feature count is:" + layer.GetFeatureCount());*/
        }
        return layer;
    }
    
    
    @Override
    public IScroll<T> scroll() throws DataAccessException {
        this.printSQL();
       // final int fetchsize = this.fetchSize == null ? IDAO.DEFAULT_FETCH_SIZE : this.fetchSize;
        Object[] args = this.parameterList.toArray(new Object[this.parameterList.size()]);
        IScroll<T> scroll;
        try {
        
            Type[] types = this.inputTypes.toArray(new Type[this.inputTypes.size()]);
            
            String sql = this.setValuesIntoSql(this.sql, args,types);
            IOgrConnection connection = this.ogrShellDataSource.connection();
            DataSource dataSource = connection.getReadShell().getDataSource();
            
            OgrScrollStatement ogrScrollStatement = null;
            int whereIndex = sql.indexOf("where");
            String fidColumn = dataSource.GetLayer(this.table.getTablename()).GetFIDColumn();
            if(StringUtils.isEmpty(fidColumn)){
                fidColumn = "FID";
            }
            Layer layer = null;
            if (whereIndex != -1 && sql.substring(whereIndex).indexOf("\"" + fidColumn + "\" in") != -1){
                List<Long> fids = Arrays.stream(args).map(arg -> Long.valueOf(arg.toString())).collect(Collectors.toList());
                ogrScrollStatement = new OgrScrollStatement(this.table, this.queryFields, this.firstResult, this.maxResults, fids);
                layer = this.executeSQL(dataSource, sql, command);
            }/*else if (this.queryFields.length == 1 && this.queryFields[0].equals(this.table.getIdField()) && command != null){//根据空间范围查询落入范围要素的主键，特殊处理，避免读取geometry占用大量资源
                ogrScrollStatement = new OgrScrollStatement(this.table, this.queryFields, this.firstResult, this.maxResults);
                Set<String> fieldNameSet = this.table.getFieldsInTableMap().keySet();
                fieldNameSet.remove(fidColumn);
                Vector<String> ignoreFields = new Vector<>(fieldNameSet.size());
                //ignoreFields.addAll(fieldNameSet);
                //ignoreFields.add("OGR_GEOMETRY");
                layer = dataSource.GetLayer(this.table.getTablename());
                layer.SetIgnoredFields(ignoreFields);
                command.build(dialect);
                Geom geom = command.getGeometry();
                geom.changeType(SPATIAL_TYPE.gdalGeometry);
                layer.SetSpatialFilter((Geometry) geom.getOriginGeom());
            }*/else {
                ogrScrollStatement = new OgrScrollStatement(this.table, this.queryFields, this.firstResult, this.maxResults);
                layer = this.executeSQL(dataSource, sql, command);
            }
            //Layer layer = this.executeSQL(dataSource, sql, command);

            scroll = this.transformer.extractDataScroll(dialect, layer, returnTypeMap, ogrScrollStatement );
           
        } catch (Exception e) {
            // TODO Auto-generated catch block
           throw new DataAccessException(e);
        }
        return scroll;
    }

}
