/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.ogr.connection;

import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.pool.OgrShellPool;
import com.northpool.resources.datasource.ogr.pool.OgrShellPoolManager;
import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import com.northpool.resources.datasource.ogr.shell.write.IOgrWriteShell;
import java.io.IOException;

public abstract class AbstractOgrConnection
implements IOgrConnection {
    IOgrReadShell readShell;
    IOgrWriteShell writeShell;
    IOgrShellDataSource dataSource;

    public AbstractOgrConnection(IOgrShellDataSource dataSource) throws IOException {
        this.dataSource = dataSource;
        OgrShellPool ogrShellPool = OgrShellPoolManager.getInstance().getOgrShellPool(dataSource);
        this.readShell = ogrShellPool.getReadShell();
    }

    @Override
    public IOgrReadShell getReadShell() {
        return this.readShell;
    }

    public void setReadShell(IOgrReadShell readShell) {
        this.readShell = readShell;
    }

    @Override
    public IOgrWriteShell getWriteShell() {
        return this.writeShell;
    }

    public void setWriteShell(IOgrWriteShell writeShell) {
        this.writeShell = writeShell;
    }
}

