/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.ogr.operate.column;

import com.northpool.resources.datatable.operate.AbstractColumn;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.ogr.OgrDialect;
import com.northpool.spatial.Constants;

public class OgrColumn
extends AbstractColumn
implements IColumn {
    public OgrColumn(String columnName, Integer columnSize, String columnTypeName, Boolean nullable, String remarks) {
        super(columnName, columnSize, null, columnTypeName, nullable, null, remarks, OgrDialect.INSTANCE);
    }

    public Constants.SPATIAL_TYPE getSpatialType() {
        return Constants.SPATIAL_TYPE.shape;
    }

    protected void initAttType() {
        this.type = this.dialect.getTypeByName(this.columnTypeName);
    }

    protected FieldDefaultValueBean getFieldDefaultValueByDefaultValue() {
        return null;
    }

    public static OgrColumn createIdColumn(String name) {
        OgrColumn column = new OgrColumn(name, 0, "Integer", false, "\u4e3b\u952e");
        column.setIsPK(true);
        FieldDefaultValueBean fieldDefaultValueBean = new FieldDefaultValueBean();
        fieldDefaultValueBean.setType(FieldDefaultValueBean.VALUE_TYPE.serial);
        column.setFieldDefaultValue(fieldDefaultValueBean);
        column.setIsSerial(true);
        return column;
    }

    public static OgrColumn createSpatialColumn(String name, Integer srid, int OGRwkbGeometryType) {
        OgrColumn column = new OgrColumn(name, 0, "geometry", false, "\u7a7a\u95f4\u5b57\u6bb5");
        column.setIsSpatial(true);
        column.setSRID(srid);
        column.setGeoType(OgrColumn.ogrwkbGeometryType2GeoType(OGRwkbGeometryType));
        column.setDimension(OgrColumn.ogrwkbGeometryType2Dimension(OGRwkbGeometryType));
        return column;
    }

    static Integer ogrwkbGeometryType2Dimension(int OGRwkbGeometryType) {
        switch (OGRwkbGeometryType) {
            case 0: {
                return 2;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 2;
            }
            case 3000: {
                return 3;
            }
            case 3001: {
                return 3;
            }
            case 3002: {
                return 3;
            }
            case 3003: {
                return 3;
            }
            case 3004: {
                return 3;
            }
            case 3005: {
                return 3;
            }
            case 3006: {
                return 3;
            }
        }
        throw new RuntimeException("\u627e\u4e0d\u5230OGRwkbGeometryType:" + OGRwkbGeometryType + "\u4e0eGEO_TYPE\u7684\u6620\u5c04\u5173\u7cfb");
    }

    static Constants.GEO_TYPE ogrwkbGeometryType2GeoType(int OGRwkbGeometryType) {
        switch (OGRwkbGeometryType) {
            case 0: {
                return Constants.GEO_TYPE.UNKNOWN;
            }
            case 1: {
                return Constants.GEO_TYPE.POINT;
            }
            case 2: {
                return Constants.GEO_TYPE.LINESTRING;
            }
            case 3: {
                return Constants.GEO_TYPE.POLYGON;
            }
            case 4: {
                return Constants.GEO_TYPE.MULTIPOINT;
            }
            case 5: {
                return Constants.GEO_TYPE.MULTILINESTRING;
            }
            case 6: {
                return Constants.GEO_TYPE.MULTIPOLYGON;
            }
            case 3000: {
                return Constants.GEO_TYPE.UNKNOWN;
            }
            case 3001: {
                return Constants.GEO_TYPE.POINT;
            }
            case 3002: {
                return Constants.GEO_TYPE.LINESTRING;
            }
            case 3003: {
                return Constants.GEO_TYPE.POLYGON;
            }
            case 3004: {
                return Constants.GEO_TYPE.MULTIPOINT;
            }
            case 3005: {
                return Constants.GEO_TYPE.MULTILINESTRING;
            }
            case 3006: {
                return Constants.GEO_TYPE.MULTIPOLYGON;
            }
        }
        throw new RuntimeException("\u627e\u4e0d\u5230OGRwkbGeometryType:" + OGRwkbGeometryType + "\u4e0eGEO_TYPE\u7684\u6620\u5c04\u5173\u7cfb");
    }
}

