/**
　 * <p>Title: PoolManager.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年4月2日
　 * @version 1.0
*/
package com.northpool.resources.datasource.ogr.pool;

import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author matt
 *
 */
public abstract class OgrShellPool<ReadShell extends IOgrReadShell> {




    ThreadLocal<ReadShell> gdalpool = new ThreadLocal<>();

    Map<Long, ReadShell> pool = new ConcurrentHashMap<>();


    synchronized void close(){
        /*ThreadLocal<FGDB_GDALShell> fgdb_gdalShellThreadLocal = gdalpool.get(file);
        if(fgdb_gdalShellThreadLocal == null){
            fgdb_gdalShellThreadLocal = new ThreadLocal<>();
            gdalpool.put(file, fgdb_gdalShellThreadLocal);
        }
        FGDB_GDALShell gdal_shell = fgdb_gdalShellThreadLocal.get();
        gdalpool.remove(file);
        if(gdal_shell != null){
            gdal_shell.close();
        }
        FGDB_ESRIShell fgdb_shell = esripool.get(file);
        esripool.remove(file);
        if(fgdb_shell != null){
            fgdb_shell.close();
        }*/
        for (ReadShell value : pool.values()) {
            value.close();
        }
    }


    public ReadShell getReadShell() throws IOException {
        Long id = Thread.currentThread().getId();
        ReadShell readShell = pool.get(id);
        if (readShell == null) {
            readShell = this.createReadShell();
        }
        return readShell;
    }


    synchronized ReadShell createReadShell() throws IOException{
        ReadShell shell = newShellInstance();
        shell.load();
        pool.put(Thread.currentThread().getId(), shell);
        return shell;
    }

    protected abstract ReadShell newShellInstance() throws IOException;

    
}
