/**
　 * <p>Title: ArrayFGDBTransformer.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月30日
　 * @version 1.0
*/
package com.northpool.resources.datatable.ogr;


import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;
import com.northpool.type.TypeOgrGeometry;
import org.gdal.ogr.Feature;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

/**
 * @author matt
 *
 */
public class ArrayOgrTransformer extends AbstractOgrTransformer<Object[]> implements IOgrTransformer<Object[]> {

   
    @Override
    protected ResultSetMapping<Object[], Cursor> getMapping() {
      
        return new ResultSetMapping<Object[],Cursor>(){
            
            @Override
            public Object[] mapping(Cursor cursor, LinkedHashMap<String, Type> typeLink,final IDialect dialect) {
                
                Feature feature = cursor.getValue();
                if (feature == null) {
                    return null;
                }
                
                IResourcesDataOutput<Feature,Integer> output = dialect.getResourcesDataOutput();
                
                Object[] values = new Object[typeLink.entrySet().size()];
                
                Iterator<Entry<String,Type>> iterator = typeLink.entrySet().iterator();
                int indexInQueryFieldArray = 0;
                //因为空间字段不在导出字段中,所以单独需要一个index
                int indexInDataOutput = 0;
                while(iterator.hasNext()){
                    Type type = iterator.next().getValue();
                    Object object = null;
                    if(type.getEnum() != TypeOgrGeometry.INSTANCE.getEnum()){
                        object = output.output(feature, type, indexInDataOutput);
                        indexInDataOutput ++;
                    }else{
                        object = output.output(feature, type, null);
                    }
                    values[indexInQueryFieldArray] = object;
                    indexInQueryFieldArray ++;
                    
                }
                feature.delete();
                return values;
                
            }

          
        };
    }

    

}
