/**
　 * <p>Title: FGDBQueryParmsDataInput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月30日
　 * @version 1.0
*/
package com.northpool.resources.dialect.ogr;


import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.type.*;

import java.util.List;

/**
 * @author matt
 *
 */
public class OgrQueryParmsDataInput implements IResourcesDataInput<List<String>,Integer> {

    public static final OgrQueryParmsDataInput INSTANCE = new OgrQueryParmsDataInput();
    
    
    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        // TODO Auto-generated method stub
        return DATA_SOURCE_TYPE.fgdb;
    }

   
    @Override
    public void columnBoolean(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{
            Boolean inputValue = (Boolean)value;
            if(inputValue){
                input.add(indexOrLabelName, "1");
            }else{
                input.add(indexOrLabelName, "0");
            }
        }
    }

  
    public void columnBigDecimal(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{   
            input.add(indexOrLabelName, TypeBigDecimal.INSTANCE.valueToString(value));
        }
    }

    
    @Override
    public void columnBytes(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        throw new RuntimeException("不支持类型");
    }

    
    @Override
    public void columnDouble(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{
            input.add(indexOrLabelName, TypeDouble.INSTANCE.valueToString(value));
        }
    }

    
    @Override
    public void columnGeometry(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        //不需要处理geometry的情况
    }

   
    @Override
    public void columnInteger(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{
            input.add(indexOrLabelName, TypeInteger.INSTANCE.valueToString(value));
        }
    }

    
    @Override
    public void columnLong(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{
            input.add(indexOrLabelName, TypeLong.INSTANCE.valueToString(value));
        }
    }

    
    @Override
    public void columnString(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{
            input.add(indexOrLabelName, "'" + TypeString.INSTANCE.valueToString(value) + "'");
        }
    }

  
    @Override
    public void columnTimestamp(List<String> input, Object value, Integer indexOrLabelName) throws Exception {
        //date '15.9.2014 14:28:58'
        if(value == null){
            throw new RuntimeException("对比值不能为空");
        }else{
            //date '15.9.2014 14:28:58'
            String timeStr = TypeTimestamp.INSTANCE.valueToString(value, "dd.MM.yyyy HH:mm:ss.SSS");
            input.add(indexOrLabelName, "data '" + timeStr + "'");
        }
        
    }

}
