/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.ogr.pool;

import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class OgrShellPool<ReadShell extends IOgrReadShell> {
    ThreadLocal<ReadShell> gdalpool = new ThreadLocal();
    Map<Long, ReadShell> pool = new ConcurrentHashMap<Long, ReadShell>();

    synchronized void close() {
        for (IOgrReadShell value : this.pool.values()) {
            value.close();
        }
    }

    public ReadShell getReadShell() throws IOException {
        Long id = Thread.currentThread().getId();
        IOgrReadShell readShell = (IOgrReadShell)this.pool.get(id);
        if (readShell == null) {
            readShell = this.createReadShell();
        }
        return (ReadShell)readShell;
    }

    synchronized ReadShell createReadShell() throws IOException {
        ReadShell shell = this.newShellInstance();
        shell.load();
        this.pool.put(Thread.currentThread().getId(), shell);
        return shell;
    }

    protected abstract ReadShell newShellInstance() throws IOException;
}

